/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.springjdk17;

import io.github.xanthic.cache.api.Cache;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class XanthicSpringCache
extends AbstractValueAdaptingCache {
    private final String name;
    private final Cache<Object, Object> cache;

    public XanthicSpringCache(String name, Cache<Object, Object> cache) {
        super(true);
        this.name = name;
        this.cache = cache;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Object getNativeCache() {
        return this.cache;
    }

    public <T> T get(@NotNull Object key, @NotNull Callable<T> valueLoader) {
        return (T)this.fromStoreValue(this.cache.computeIfAbsent(key, k -> {
            try {
                return this.toStoreValue(valueLoader.call());
            }
            catch (Exception e) {
                throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
            }
        }));
    }

    public void put(@NotNull Object key, Object value) {
        this.cache.put(key, this.toStoreValue(value));
    }

    public Cache.ValueWrapper putIfAbsent(@NotNull Object key, Object value) {
        return this.toValueWrapper(this.cache.putIfAbsent(key, this.toStoreValue(value)));
    }

    public void evict(@NotNull Object key) {
        this.cache.remove(key);
    }

    public boolean evictIfPresent(@NotNull Object key) {
        return this.cache.remove(key) != null;
    }

    public void clear() {
        this.cache.clear();
    }

    protected Object lookup(@NotNull Object key) {
        return this.cache.get(key);
    }

    public CompletableFuture<?> retrieve(@NotNull Object key) {
        Object value = this.lookup(key);
        if (value == null) {
            return null;
        }
        return CompletableFuture.completedFuture(this.toValueWrapper(value));
    }

    @NotNull
    public <T> CompletableFuture<T> retrieve(@NotNull Object key, @NotNull Supplier<CompletableFuture<T>> valueLoader) {
        return CompletableFuture.supplyAsync(() -> this.fromStoreValue(this.cache.computeIfAbsent(key, arg_0 -> this.lambda$retrieve$1((Supplier)valueLoader, arg_0))));
    }

    private /* synthetic */ Object lambda$retrieve$1(Supplier valueLoader, Object k) {
        return this.toStoreValue(((CompletableFuture)valueLoader.get()).join());
    }
}

