/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.raphimc.noteblocklib.format.mcsp.model.McSpHeader;
import net.raphimc.noteblocklib.format.mcsp.model.McSpLayer;
import net.raphimc.noteblocklib.format.mcsp.model.McSpNote;
import net.raphimc.noteblocklib.model.Data;
import net.raphimc.noteblocklib.util.Instrument;

public class McSpData
implements Data<McSpNote> {
    private List<McSpLayer> layers;
    private static final Pattern NOTE_DATA_PATTERN = Pattern.compile("(\\d+)?>(.)");

    public McSpData(McSpHeader header, Scanner scanner) {
        this.layers = new ArrayList<McSpLayer>();
        scanner.useDelimiter("[|\\n]");
        if (header.getVersion() == 2) {
            for (int i = 0; i < 6; ++i) {
                scanner.next();
            }
            int tick = 0;
            while (scanner.hasNext()) {
                tick += scanner.nextInt();
                Matcher noteData = NOTE_DATA_PATTERN.matcher(scanner.next());
                int layer = 0;
                while (noteData.find()) {
                    if (noteData.groupCount() == 2) {
                        layer += Integer.parseInt(noteData.group(1));
                        while (this.layers.size() <= layer) {
                            this.layers.add(new McSpLayer());
                        }
                        this.layers.get(layer).getNotesAtTick().put(tick, new McSpNote(noteData.group(2).charAt(0)));
                        continue;
                    }
                    if (noteData.groupCount() == 1) {
                        if (this.layers.isEmpty()) {
                            this.layers.add(new McSpLayer());
                        }
                        this.layers.get(layer).getNotesAtTick().put(tick, new McSpNote(noteData.group(1).charAt(0)));
                        continue;
                    }
                    if (noteData.groupCount() == 0) continue;
                    throw new IllegalArgumentException("Invalid note data: " + noteData.group(0));
                }
            }
        } else if (header.getVersion() == 0) {
            scanner.next();
            int tick = 0;
            while (scanner.hasNext()) {
                tick += scanner.nextInt();
                char[] noteData = scanner.next().toCharArray();
                if (noteData.length != 14) {
                    throw new IllegalArgumentException("Invalid note data: " + new String(noteData));
                }
                for (int layer = 0; layer <= 6; ++layer) {
                    int instrument = noteData[layer * 2] - 48;
                    int key = noteData[layer * 2 + 1] - 65;
                    if (instrument == 0) continue;
                    while (this.layers.size() <= layer) {
                        this.layers.add(new McSpLayer());
                    }
                    this.layers.get(layer).getNotesAtTick().put(tick, new McSpNote((byte)key, Instrument.fromNbsId((byte)(instrument - 1))));
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported MCSP version: " + header.getVersion());
        }
    }

    public McSpData(List<McSpLayer> layers) {
        this.layers = layers;
    }

    public List<McSpLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<McSpLayer> layers) {
        this.layers = layers;
    }
}

