/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.player;

import net.raphimc.noteblocklib.format.nbs.NbsDefinitions;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.NoteWithPanning;
import net.raphimc.noteblocklib.model.NoteWithVolume;
import net.raphimc.noteblocklib.player.NoteConsumer;
import net.raphimc.noteblocklib.util.Instrument;
import net.raphimc.noteblocklib.util.MinecraftDefinitions;

public interface FullNoteConsumer
extends NoteConsumer {
    @Override
    default public void playNote(Note note) {
        float pitch;
        float panning;
        float volume;
        if (note instanceof NoteWithVolume) {
            NoteWithVolume noteWithVolume = (NoteWithVolume)((Object)note);
            volume = noteWithVolume.getVolume();
        } else {
            volume = 100.0f;
        }
        if (volume <= 0.0f) {
            return;
        }
        if (note instanceof NoteWithPanning) {
            NoteWithPanning noteWithPanning = (NoteWithPanning)((Object)note);
            panning = noteWithPanning.getPanning();
        } else {
            panning = 0.0f;
        }
        if (note instanceof NbsNote) {
            NbsNote nbsNote = (NbsNote)note;
            if (nbsNote.getCustomInstrument() != null) {
                nbsNote = nbsNote.clone();
                nbsNote.setKey((byte)(nbsNote.getKey() + nbsNote.getCustomInstrument().getPitch() - 45));
            }
            pitch = MinecraftDefinitions.nbsPitchToMcPitch(NbsDefinitions.getPitch(nbsNote));
        } else {
            pitch = MinecraftDefinitions.mcKeyToMcPitch(MinecraftDefinitions.nbsKeyToMcKey(note.getKey()));
        }
        float playerVolume = volume / 100.0f;
        float playerPanning = panning / 100.0f;
        if (note.getInstrument() != null) {
            this.playNote(note.getInstrument(), pitch, playerVolume, playerPanning);
        } else if (note instanceof NbsNote && ((NbsNote)note).getCustomInstrument() != null) {
            this.playCustomNote(((NbsNote)note).getCustomInstrument(), pitch, playerVolume, playerPanning);
        }
    }

    public void playNote(Instrument var1, float var2, float var3, float var4);

    default public void playCustomNote(NbsCustomInstrument customInstrument, float pitch, float volume, float panning) {
    }
}

