/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp2.model;

import java.util.Objects;

public class McSp2Note {
    private byte instrument;
    private byte key;

    public byte getInstrument() {
        return this.instrument;
    }

    public McSp2Note setInstrument(byte instrument) {
        this.instrument = instrument;
        return this;
    }

    public byte getKey() {
        return this.key;
    }

    public McSp2Note setKey(byte key) {
        this.key = key;
        return this;
    }

    public McSp2Note setInstrumentAndKey(char data) {
        int index = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\u00a7\u00bd#\u00a3\u00a4$%&/{[(])=}?\\+\u00b4`^~\u00a8*'.;,:-_<\u00b5\u20ac\u00cc\u00ec\u00ed\u00cd\u00ef\u00cf\u00ee\u00ce\u00f3\u00d3\u00f2\u00d2\u00f6\u00d6\u00e5\u00c5\u00e4\u00c4\u00f1\u00d1\u00f5\u00d5\u00fa\u00da\u00f9\u00d9\u00fc\u00fb\u00dc\u00db\u00e9\u00c9\u00e8\u00c8\u00ea\u00ca\u00eb".indexOf(data);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid note data: " + data);
        }
        this.instrument = (byte)(index / 25);
        this.key = (byte)(index % 25);
        return this;
    }

    public char getInstrumentAndKey() {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\u00a7\u00bd#\u00a3\u00a4$%&/{[(])=}?\\+\u00b4`^~\u00a8*'.;,:-_<\u00b5\u20ac\u00cc\u00ec\u00ed\u00cd\u00ef\u00cf\u00ee\u00ce\u00f3\u00d3\u00f2\u00d2\u00f6\u00d6\u00e5\u00c5\u00e4\u00c4\u00f1\u00d1\u00f5\u00d5\u00fa\u00da\u00f9\u00d9\u00fc\u00fb\u00dc\u00db\u00e9\u00c9\u00e8\u00c8\u00ea\u00ca\u00eb".charAt(this.instrument * 25 + this.key);
    }

    public McSp2Note copy() {
        McSp2Note copyNote = new McSp2Note();
        copyNote.setInstrument(this.getInstrument());
        copyNote.setKey(this.getKey());
        return copyNote;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        McSp2Note mcSp2Note = (McSp2Note)o;
        return this.instrument == mcSp2Note.instrument && this.key == mcSp2Note.key;
    }

    public int hashCode() {
        return Objects.hash(this.instrument, this.key);
    }
}

