/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAXStreamer
extends TreeBuilder<Attributes> {
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;

    SAXStreamer() {
    }

    protected void addAttributesToElement(Attributes element, HtmlAttributes attributes) throws SAXException {
        Attributes existingAttrs = element;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName = attributes.getQName(i);
            if (existingAttrs.getIndex(qName) >= 0) continue;
            this.fatal();
        }
    }

    protected void appendCharacters(Attributes parent, char[] buf, int start, int length) throws SAXException {
        this.contentHandler.characters(buf, start, length);
    }

    protected void appendChildrenToNewParent(Attributes oldParent, Attributes newParent) throws SAXException {
        this.fatal();
    }

    protected void appendComment(Attributes parent, char[] buf, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(buf, start, length);
        }
    }

    protected void appendCommentToDocument(char[] buf, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(buf, start, length);
        }
    }

    protected Attributes createElement(String ns, String name, HtmlAttributes attributes) throws SAXException {
        return attributes;
    }

    protected Attributes createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        return attributes;
    }

    protected void detachFromParent(Attributes element) throws SAXException {
        this.fatal();
    }

    protected void appendElement(Attributes child, Attributes newParent) throws SAXException {
    }

    protected boolean hasChildren(Attributes element) throws SAXException {
        return false;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    protected void appendDoctypeToDocument(String name, String publicIdentifier, String systemIdentifier) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicIdentifier, systemIdentifier);
            this.lexicalHandler.endDTD();
        }
    }

    protected void elementPopped(String ns, String name, Attributes node) throws SAXException {
        this.contentHandler.endElement(ns, name, name);
    }

    protected void elementPushed(String ns, String name, Attributes node) throws SAXException {
        this.contentHandler.startElement(ns, name, name, node);
    }

    protected void end() throws SAXException {
        this.contentHandler.endDocument();
    }

    protected void start(boolean fragment) throws SAXException {
        this.contentHandler.setDocumentLocator((Locator)this.tokenizer);
        if (!fragment) {
            this.contentHandler.startDocument();
        }
    }

    protected void fatal() throws SAXException {
        SAXParseException spe = new SAXParseException("Cannot recover after last error. Any further errors will be ignored.", (Locator)this.tokenizer);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    protected void insertFosterParentedCharacters(char[] buf, int start, int length, Attributes table, Attributes stackParent) throws SAXException {
        this.fatal();
    }

    protected void insertFosterParentedChild(Attributes child, Attributes table, Attributes stackParent) throws SAXException {
        this.fatal();
    }
}

