/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.saxtree.Characters;
import nu.validator.saxtree.Comment;
import nu.validator.saxtree.DTD;
import nu.validator.saxtree.Document;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.Element;
import nu.validator.saxtree.Node;
import nu.validator.saxtree.ParentNode;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAXTreeBuilder
extends TreeBuilder<Element> {
    private Document document;
    private Node cachedTable = null;
    private Node cachedTablePreviousSibling = null;

    SAXTreeBuilder() {
    }

    protected void appendComment(Element parent, char[] buf, int start, int length) {
        parent.appendChild((Node)new Comment((Locator)this.tokenizer, buf, start, length));
    }

    protected void appendCommentToDocument(char[] buf, int start, int length) {
        this.document.appendChild((Node)new Comment((Locator)this.tokenizer, buf, start, length));
    }

    protected void appendCharacters(Element parent, char[] buf, int start, int length) {
        parent.appendChild((Node)new Characters((Locator)this.tokenizer, buf, start, length));
    }

    protected boolean hasChildren(Element element) {
        return element.getFirstChild() != null;
    }

    protected void appendElement(Element child, Element newParent) {
        newParent.appendChild((Node)child);
    }

    protected Element createHtmlElementSetAsRoot(HtmlAttributes attributes) {
        Element newElt = new Element((Locator)this.tokenizer, "http://www.w3.org/1999/xhtml", "html", "html", (Attributes)attributes, true, null);
        this.document.appendChild((Node)newElt);
        return newElt;
    }

    protected void addAttributesToElement(Element element, HtmlAttributes attributes) throws SAXException {
        HtmlAttributes existingAttrs = (HtmlAttributes)element.getAttributes();
        existingAttrs.merge(attributes);
    }

    protected void appendDoctypeToDocument(String name, String publicIdentifier, String systemIdentifier) {
        DTD dtd = new DTD((Locator)this.tokenizer, name, publicIdentifier, systemIdentifier);
        dtd.setEndLocator((Locator)this.tokenizer);
        this.document.appendChild((Node)dtd);
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    DocumentFragment getDocumentFragment() {
        DocumentFragment rv = new DocumentFragment();
        rv.appendChildren(this.document.getFirstChild());
        this.document = null;
        return rv;
    }

    protected void end() throws SAXException {
        this.document.setEndLocator((Locator)this.tokenizer);
        this.cachedTable = null;
        this.cachedTablePreviousSibling = null;
    }

    protected void start(boolean fragment) {
        this.document = new Document((Locator)this.tokenizer);
        this.cachedTable = null;
        this.cachedTablePreviousSibling = null;
    }

    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        newParent.appendChildren((Node)oldParent);
    }

    protected Element createElement(String ns, String name, HtmlAttributes attributes) throws SAXException {
        return new Element((Locator)this.tokenizer, ns, name, name, (Attributes)attributes, true, null);
    }

    protected void insertFosterParentedCharacters(char[] buf, int start, int length, Element table, Element stackParent) throws SAXException {
        Characters child = new Characters((Locator)this.tokenizer, buf, start, length);
        ParentNode parent = table.getParentNode();
        if (parent != null) {
            parent.insertBetween((Node)child, this.previousSibling((Node)table), (Node)table);
            this.cachedTablePreviousSibling = child;
        } else {
            stackParent.appendChild((Node)child);
        }
    }

    protected void insertFosterParentedChild(Element child, Element table, Element stackParent) throws SAXException {
        ParentNode parent = table.getParentNode();
        if (parent != null) {
            parent.insertBetween((Node)child, this.previousSibling((Node)table), (Node)table);
            this.cachedTablePreviousSibling = child;
        } else {
            stackParent.appendChild((Node)child);
        }
    }

    private Node previousSibling(Node table) {
        if (table == this.cachedTable) {
            return this.cachedTablePreviousSibling;
        }
        this.cachedTable = table;
        this.cachedTablePreviousSibling = table.getPreviousSibling();
        return this.cachedTablePreviousSibling;
    }

    protected void detachFromParent(Element element) throws SAXException {
        element.detach();
    }
}

