/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.Background;
import org.androidannotations.api.BackgroundExecutor;
import org.androidannotations.handler.AbstractRunnableHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentHolder;

public class BackgroundHandler
extends AbstractRunnableHandler {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public BackgroundHandler(ProcessingEnvironment processingEnvironment) {
        super(Background.class, processingEnvironment);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(delegatingMethod);
        JDefinedClass anonymousTaskClass = this.codeModel().anonymousClass(BackgroundExecutor.Task.class);
        JMethod executeMethod = anonymousTaskClass.method(1, this.codeModel().VOID, "execute");
        executeMethod.annotate(Override.class);
        JTryBlock tryBlock = executeMethod.body()._try();
        tryBlock.body().add(previousMethodBody);
        JCatchBlock catchBlock = tryBlock._catch(holder.classes().THROWABLE);
        JVar caughtException = catchBlock.param("e");
        JInvocation uncaughtExceptionCall = holder.classes().THREAD.staticInvoke("getDefaultUncaughtExceptionHandler").invoke("uncaughtException").arg(holder.classes().THREAD.staticInvoke("currentThread")).arg(caughtException);
        catchBlock.body().add(uncaughtExceptionCall);
        Background annotation = element.getAnnotation(Background.class);
        String id = annotation.id();
        int delay = annotation.delay();
        String serial = annotation.serial();
        JClass backgroundExecutorClass = this.refClass(BackgroundExecutor.class);
        JInvocation newTask = JExpr._new(anonymousTaskClass).arg(JExpr.lit(id)).arg(JExpr.lit(delay)).arg(JExpr.lit(serial));
        JInvocation executeCall = backgroundExecutorClass.staticInvoke("execute").arg(newTask);
        delegatingMethod.body().add(executeCall);
    }
}

