/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.annotations.EActivity;
import org.androidannotations.handler.BaseGeneratingAnnotationHandler;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;

public class EActivityHandler
extends BaseGeneratingAnnotationHandler<EActivityHolder> {
    private AnnotationHelper annotationHelper;

    public EActivityHandler(ProcessingEnvironment processingEnvironment) {
        super(EActivity.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
    }

    @Override
    public EActivityHolder createGeneratedClassHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        return new EActivityHolder(processHolder, annotatedElement, this.androidManifest);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        this.validatorHelper.extendsActivity(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.ALLOW_NO_RES_ID, valid);
        this.validatorHelper.componentRegistered(element, this.androidManifest, valid);
    }

    @Override
    public void process(Element element, EActivityHolder holder) {
        List<JFieldRef> fieldRefs = this.annotationHelper.extractAnnotationFieldRefs(this.processHolder, element, this.getTarget(), this.rClass.get(IRClass.Res.LAYOUT), false);
        JFieldRef contentViewId = null;
        if (fieldRefs.size() == 1) {
            contentViewId = fieldRefs.get(0);
        }
        if (contentViewId != null) {
            JBlock onCreateBody = holder.getOnCreate().body();
            JMethod setContentView = holder.getSetContentViewLayout();
            onCreateBody.invoke(setContentView).arg(contentViewId);
        }
    }
}

