/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.androidannotations.annotations.OrmLiteDao;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class OrmLiteDaoHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private TargetAnnotationHelper helper;
    private DeclaredType daoParametrizedType;
    private DeclaredType runtimeExceptionDaoParametrizedType;

    public OrmLiteDaoHandler(ProcessingEnvironment processingEnvironment) {
        super(OrmLiteDao.class, processingEnvironment);
        this.helper = new TargetAnnotationHelper(this.processingEnv, this.getTarget());
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.hasOrmLiteJars(element, valid);
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.extendsOrmLiteDao(element, valid);
        this.validatorHelper.hasASqlLiteOpenHelperParameterizedType(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        this.createDaoParametrizedTypes();
        String fieldName = element.getSimpleName().toString();
        JClass modelClass = this.getEntityAndIdClass(element, holder);
        JExpression modelClassDotClass = modelClass.dotclass();
        TypeMirror databaseHelperTypeMirror = (TypeMirror)this.helper.extractAnnotationParameter(element, "helper");
        JFieldVar databaseHelperRef = holder.getDatabaseHelperRef(databaseHelperTypeMirror);
        JBlock initBody = holder.getInitBody();
        JInvocation injectExpr = this.elementExtendsRuntimeExceptionDao(element) ? this.classes().RUNTIME_EXCEPTION_DAO.staticInvoke("createDao").arg(databaseHelperRef.invoke("getConnectionSource")).arg(modelClassDotClass) : databaseHelperRef.invoke("getDao").arg(modelClassDotClass);
        JTryBlock tryBlock = initBody._try();
        tryBlock.body().assign(JExpr.ref(fieldName), injectExpr);
        JCatchBlock catchBlock = tryBlock._catch(this.classes().SQL_EXCEPTION);
        JVar exception = catchBlock.param("e");
        catchBlock.body().staticInvoke(this.classes().LOG, "e").arg(holder.getGeneratedClass().name()).arg("Could not create DAO " + fieldName).arg(exception);
    }

    private boolean elementExtendsRuntimeExceptionDao(Element element) {
        TypeMirror elementType = element.asType();
        return this.helper.isSubtype(elementType, this.runtimeExceptionDaoParametrizedType);
    }

    private JClass getEntityAndIdClass(Element element, EComponentHolder holder) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        if (this.isSubtypeOfDao(element.asType()) && (typeArguments = (declaredType = (DeclaredType)element.asType()).getTypeArguments()).size() == 2) {
            return holder.refClass(typeArguments.get(0).toString());
        }
        List<? extends TypeMirror> superTypes = this.helper.directSupertypes(element.asType());
        for (TypeMirror typeMirror : superTypes) {
            DeclaredType superDeclaredType;
            List<? extends TypeMirror> typeArguments2;
            if (typeMirror.getKind() != TypeKind.DECLARED || !this.isSubtypeOfDao(typeMirror) || (typeArguments2 = (superDeclaredType = (DeclaredType)typeMirror).getTypeArguments()).size() != 2) continue;
            return holder.refClass(typeArguments2.get(0).toString());
        }
        return null;
    }

    private boolean isSubtypeOfDao(TypeMirror type) {
        return this.helper.isSubtype(type, this.daoParametrizedType) || this.helper.isSubtype(type, this.runtimeExceptionDaoParametrizedType);
    }

    private void createDaoParametrizedTypes() {
        WildcardType wildcardType = this.helper.getTypeUtils().getWildcardType(null, null);
        TypeElement daoTypeElement = this.helper.typeElementFromQualifiedName("com.j256.ormlite.dao.Dao");
        this.daoParametrizedType = this.helper.getTypeUtils().getDeclaredType(daoTypeElement, wildcardType, wildcardType);
        TypeElement runtimeExceptionDaoTypeElement = this.helper.typeElementFromQualifiedName("com.j256.ormlite.dao.RuntimeExceptionDao");
        this.runtimeExceptionDaoParametrizedType = this.helper.getTypeUtils().getDeclaredType(runtimeExceptionDaoTypeElement, wildcardType, wildcardType);
    }
}

