/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IntentBuilder;
import org.androidannotations.holder.HasIntentBuilder;

public class ActivityIntentBuilder
extends IntentBuilder {
    private static final int MIN_SDK_WITH_FRAGMENT_SUPPORT = 11;
    private JFieldVar fragmentField;
    private JFieldVar fragmentSupportField;

    public ActivityIntentBuilder(HasIntentBuilder holder, AndroidManifest androidManifest) {
        super(holder, androidManifest);
    }

    @Override
    public void build() throws JClassAlreadyExistsException {
        super.build();
        this.createAdditionalConstructor();
        this.createAdditionalIntentMethods();
        this.overrideStartForResultMethod();
    }

    private void createAdditionalIntentMethods() {
        JVar fragmentParam;
        JMethod method;
        if (this.hasFragmentInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param(this.holder.classes().FRAGMENT, "fragment");
            method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(fragmentParam));
        }
        if (this.hasFragmentSupportInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param(this.holder.classes().SUPPORT_V4_FRAGMENT, "supportFragment");
            method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(fragmentParam));
        }
    }

    @Override
    protected JClass getSuperClass() {
        JClass superClass = this.holder.refClass(org.androidannotations.api.builder.ActivityIntentBuilder.class);
        return superClass.narrow((JClass)this.builderClass);
    }

    private void createAdditionalConstructor() {
        if (this.hasFragmentInClasspath()) {
            this.fragmentField = this.addFragmentConstructor(this.holder.classes().FRAGMENT, "fragment_");
        }
        if (this.hasFragmentSupportInClasspath()) {
            this.fragmentSupportField = this.addFragmentConstructor(this.holder.classes().SUPPORT_V4_FRAGMENT, "fragmentSupport_");
        }
    }

    private JFieldVar addFragmentConstructor(JClass fragmentClass, String fieldName) {
        JFieldVar fragmentField = this.holder.getIntentBuilderClass().field(4, fragmentClass, fieldName);
        JExpression generatedClass = this.holder.getGeneratedClass().dotclass();
        JMethod constructor = this.holder.getIntentBuilderClass().constructor(1);
        JVar constructorFragmentParam = constructor.param(fragmentClass, "fragment");
        JBlock constructorBody = constructor.body();
        constructorBody.invoke("super").arg(constructorFragmentParam.invoke("getActivity")).arg(generatedClass);
        constructorBody.assign(fragmentField, constructorFragmentParam);
        return fragmentField;
    }

    private void overrideStartForResultMethod() {
        if (this.fragmentSupportField == null && this.fragmentField == null) {
            return;
        }
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.holder.codeModel().VOID, "startForResult");
        method.annotate(Override.class);
        JVar requestCode = method.param(this.holder.codeModel().INT, "requestCode");
        JBlock body = method.body();
        JConditional condition = null;
        if (this.fragmentSupportField != null) {
            condition = body._if(this.fragmentSupportField.ne(JExpr._null()));
            condition._then().invoke((JExpression)this.fragmentSupportField, "startActivityForResult").arg(this.intentField).arg(requestCode);
        }
        if (this.fragmentField != null) {
            condition = condition == null ? body._if(this.fragmentField.ne(JExpr._null())) : condition._elseif(this.fragmentField.ne(JExpr._null()));
            condition._then().invoke((JExpression)this.fragmentField, "startActivityForResult").arg(this.intentField).arg(requestCode);
        }
        condition._else().invoke(JExpr._super(), "startForResult").arg(requestCode);
    }

    protected boolean hasFragmentInClasspath() {
        boolean fragmentExistsInSdk = this.androidManifest.getMinSdkVersion() >= 11;
        return fragmentExistsInSdk && this.elementUtils.getTypeElement("android.app.Fragment") != null;
    }

    protected boolean hasFragmentSupportInClasspath() {
        return this.elementUtils.getTypeElement("android.support.v4.app.Fragment") != null;
    }
}

