/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationArrayParamExtractor;
import org.androidannotations.holder.GeneratedClassHolder;

public class AnnotationParamExtractor
extends SimpleAnnotationValueVisitor6<Void, String> {
    private JAnnotationUse use;
    private GeneratedClassHolder holder;
    private APTCodeModelHelper helper;

    public AnnotationParamExtractor(JAnnotationUse use, GeneratedClassHolder holder, APTCodeModelHelper helper) {
        this.use = use;
        this.holder = holder;
        this.helper = helper;
    }

    @Override
    public Void visitArray(List<? extends AnnotationValue> vals, String p) {
        JAnnotationArrayMember paramArray = this.use.paramArray(p);
        for (AnnotationValue annotationValue : vals) {
            annotationValue.accept(new AnnotationArrayParamExtractor(this.holder, this.helper), paramArray);
        }
        return null;
    }

    @Override
    public Void visitBoolean(boolean b, String p) {
        this.use.param(p, b);
        return null;
    }

    @Override
    public Void visitByte(byte b, String p) {
        this.use.param(p, b);
        return null;
    }

    @Override
    public Void visitChar(char c, String p) {
        this.use.param(p, c);
        return null;
    }

    @Override
    public Void visitDouble(double d, String p) {
        this.use.param(p, d);
        return null;
    }

    @Override
    public Void visitFloat(float f, String p) {
        this.use.param(p, f);
        return null;
    }

    @Override
    public Void visitInt(int i, String p) {
        this.use.param(p, i);
        return null;
    }

    @Override
    public Void visitLong(long i, String p) {
        this.use.param(p, i);
        return null;
    }

    @Override
    public Void visitShort(short s, String p) {
        this.use.param(p, s);
        return null;
    }

    @Override
    public Void visitString(String s, String p) {
        this.use.param(p, s);
        return null;
    }

    @Override
    public Void visitEnumConstant(VariableElement c, String p) {
        JClass annotationClass = this.helper.typeMirrorToJClass(c.asType(), this.holder);
        JExpression expression = JExpr.direct(annotationClass.fullName() + "." + c.getSimpleName());
        this.use.param(p, expression);
        return null;
    }

    @Override
    public Void visitType(TypeMirror t, String p) {
        JClass annotationClass = this.helper.typeMirrorToJClass(t, this.holder);
        JExpression dotclass = JExpr.dotclass(annotationClass);
        this.use.param(p, dotclass);
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationMirror a, String p) {
        try {
            JClass annotationJClass = this.helper.typeMirrorToJClass(a.getAnnotationType(), this.holder);
            Constructor constructor = JAnnotationUse.class.getDeclaredConstructor(JClass.class);
            constructor.setAccessible(true);
            JAnnotationUse paramAnnotation = (JAnnotationUse)constructor.newInstance(annotationJClass);
            Map<? extends ExecutableElement, ? extends AnnotationValue> parameters = a.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> param : parameters.entrySet()) {
                param.getValue().accept(new AnnotationParamExtractor(paramAnnotation, this.holder, this.helper), param.getKey().getSimpleName().toString());
            }
            Method addValueMethod = this.use.getClass().getDeclaredMethod("addValue", String.class, JAnnotationValue.class);
            addValueMethod.setAccessible(true);
            addValueMethod.invoke((Object)this.use, p, paramAnnotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

