/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JFieldRef;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.IRInnerClass;

public class IdAnnotationHelper
extends TargetAnnotationHelper {
    private final IRClass rClass;

    public IdAnnotationHelper(ProcessingEnvironment processingEnv, String annotationName, IRClass rClass) {
        super(processingEnv, annotationName);
        this.rClass = rClass;
    }

    public boolean containsIdValue(Integer idValue, IRClass.Res res) {
        IRInnerClass rInnerClass = this.rClass.get(res);
        return rInnerClass.containsIdValue(idValue);
    }

    public boolean containsField(String name, IRClass.Res res) {
        IRInnerClass rInnerClass = this.rClass.get(res);
        return rInnerClass.containsField(name);
    }

    public List<String> extractAnnotationResources(Element element, IRClass.Res res, boolean useElementName) {
        return super.extractAnnotationResources(element, this.getTarget(), this.rClass.get(res), useElementName);
    }

    public List<JFieldRef> extractAnnotationFieldRefs(ProcessHolder holder, Element element, IRClass.Res res, boolean useElementName) {
        return this.extractAnnotationFieldRefs(holder, element, res, useElementName, "value", "resName");
    }

    public List<JFieldRef> extractAnnotationFieldRefs(ProcessHolder holder, Element element, IRClass.Res res, boolean useElementName, String idFieldName, String resFieldName) {
        return super.extractAnnotationFieldRefs(holder, element, this.getTarget(), this.rClass.get(res), useElementName, idFieldName, resFieldName);
    }

    public JFieldRef extractOneAnnotationFieldRef(ProcessHolder holder, Element element, IRClass.Res res, boolean useElementName) {
        return this.extractOneAnnotationFieldRef(holder, element, this.getTarget(), res, useElementName);
    }

    public JFieldRef extractOneAnnotationFieldRef(ProcessHolder holder, Element element, String annotationName, IRClass.Res res, boolean useElementName) {
        return this.extractOneAnnotationFieldRef(holder, element, annotationName, res, useElementName, "value", "resName");
    }

    public JFieldRef extractOneAnnotationFieldRef(ProcessHolder holder, Element element, String annotationName, IRClass.Res res, boolean useElementName, String idFieldName, String resFieldName) {
        return this.extractOneAnnotationFieldRef(holder, element, annotationName, this.rClass.get(res), useElementName, idFieldName, resFieldName);
    }

    public JFieldRef extractOneAnnotationFieldRef(ProcessHolder holder, Element element, String annotationName, IRInnerClass rInnerClass, boolean useElementName, String idFieldName, String resFieldName) {
        List<JFieldRef> jFieldRefs = this.extractAnnotationFieldRefs(holder, element, annotationName, rInnerClass, useElementName, idFieldName, resFieldName);
        if (jFieldRefs.size() == 1) {
            return jFieldRefs.get(0);
        }
        return null;
    }
}

