/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import org.androidannotations.logger.Level;

public class OptionsHelper {
    private final Map<String, String> options;

    public OptionsHelper(ProcessingEnvironment processingEnvironment) {
        this.options = processingEnvironment.getOptions();
    }

    public static Set<String> getOptionsConstants() {
        TreeSet<String> set = new TreeSet<String>();
        for (Option optionEnum : Option.values()) {
            set.add(optionEnum.getKey());
        }
        return set;
    }

    public boolean shouldLogTrace() {
        return this.getBoolean(Option.TRACE);
    }

    public String getAndroidManifestFile() {
        return this.getString(Option.ANDROID_MANIFEST_FILE);
    }

    public String getResourcePackageName() {
        return this.getString(Option.RESOURCE_PACKAGE_NAME);
    }

    public String getLogFile() {
        return this.getString(Option.LOG_FILE);
    }

    public Level getLogLevel() {
        try {
            return Level.parse(this.getString(Option.LOG_LEVEL));
        }
        catch (Exception e) {
            return Level.DEBUG;
        }
    }

    public boolean shouldUseConsoleAppender() {
        return this.getBoolean(Option.LOG_APPENDER_CONSOLE);
    }

    private String getString(Option option) {
        return this.options.get(option.getKey());
    }

    private boolean getBoolean(Option option) {
        String key = option.getKey();
        if (this.options.containsKey(key)) {
            String trace = this.options.get(key);
            return !"false".equals(trace);
        }
        return false;
    }

    static enum Option {
        TRACE("trace"),
        ANDROID_MANIFEST_FILE("androidManifestFile"),
        RESOURCE_PACKAGE_NAME("resourcePackageName"),
        LOG_FILE("logFile"),
        LOG_LEVEL("logLevel"),
        LOG_APPENDER_CONSOLE("logAppenderConsole");

        private String key;

        private Option(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

