/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.androidannotations.annotations.rest.Accept;
import org.androidannotations.annotations.rest.RequiresAuthentication;
import org.androidannotations.annotations.rest.RequiresCookie;
import org.androidannotations.annotations.rest.RequiresCookieInUrl;
import org.androidannotations.annotations.rest.RequiresHeader;
import org.androidannotations.annotations.rest.SetsCookie;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.holder.RestHolder;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;

public class RestAnnotationHelper
extends TargetAnnotationHelper {
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");

    public RestAnnotationHelper(ProcessingEnvironment processingEnv, String annotationName) {
        super(processingEnv, annotationName);
    }

    public void urlVariableNamesExistInParameters(ExecutableElement element, Set<String> variableNames, IsValid valid) {
        List<? extends VariableElement> parameters = element.getParameters();
        ArrayList<String> parametersName = new ArrayList<String>();
        for (VariableElement variableElement : parameters) {
            parametersName.add(variableElement.getSimpleName().toString());
        }
        String[] cookiesToUrl = RestAnnotationHelper.requiredUrlCookies(element);
        if (cookiesToUrl != null) {
            for (String cookie : cookiesToUrl) {
                parametersName.add(cookie);
            }
        }
        for (String variableName : variableNames) {
            if (parametersName.contains(variableName)) continue;
            valid.invalidate();
            this.printAnnotationError(element, "%s annotated method has an url variable which name could not be found in the method parameters: " + variableName);
            return;
        }
    }

    public void urlVariableNamesExistInParametersAndHasNoOneMoreParameter(ExecutableElement element, IsValid valid) {
        if (valid.isValid()) {
            List<? extends VariableElement> parameters;
            Set<String> variableNames = this.extractUrlVariableNames(element);
            this.urlVariableNamesExistInParameters(element, variableNames, valid);
            if (valid.isValid() && (parameters = element.getParameters()).size() > variableNames.size()) {
                valid.invalidate();
                this.printAnnotationError(element, "%s annotated method has only url variables in the method parameters");
            }
        }
    }

    public void urlVariableNamesExistInParametersAndHasOnlyOneMoreParameter(ExecutableElement element, IsValid valid) {
        if (valid.isValid()) {
            List<? extends VariableElement> parameters;
            Set<String> variableNames = this.extractUrlVariableNames(element);
            this.urlVariableNamesExistInParameters(element, variableNames, valid);
            if (valid.isValid() && (parameters = element.getParameters()).size() > variableNames.size() + 1) {
                valid.invalidate();
                this.printAnnotationError(element, "%s annotated method has more than one entity parameter");
            }
        }
    }

    public Set<String> extractUrlVariableNames(ExecutableElement element) {
        boolean hasValueInAnnotation;
        HashSet<String> variableNames = new HashSet<String>();
        String uriTemplate = (String)this.extractAnnotationValueParameter(element);
        boolean bl = hasValueInAnnotation = uriTemplate != null;
        if (hasValueInAnnotation) {
            Matcher m = NAMES_PATTERN.matcher(uriTemplate);
            while (m.find()) {
                variableNames.add(m.group(1));
            }
        }
        return variableNames;
    }

    public JVar declareUrlVariables(ExecutableElement element, RestHolder holder, JBlock methodBody, TreeMap<String, JVar> methodParams) {
        Set<String> urlVariables = this.extractUrlVariableNames(element);
        String[] cookiesToUrl = RestAnnotationHelper.requiredUrlCookies(element);
        if (cookiesToUrl != null) {
            for (String cookie : cookiesToUrl) {
                urlVariables.add(cookie);
            }
        }
        JClass hashMapClass = holder.classes().HASH_MAP.narrow(String.class, Object.class);
        if (!urlVariables.isEmpty()) {
            JVar hashMapVar = methodBody.decl(hashMapClass, "urlVariables", JExpr._new(hashMapClass));
            for (String urlVariable : urlVariables) {
                JVar methodParam = methodParams.get(urlVariable);
                if (methodParam != null) {
                    methodBody.invoke((JExpression)hashMapVar, "put").arg(urlVariable).arg(methodParam);
                    methodParams.remove(urlVariable);
                    continue;
                }
                JInvocation cookieValue = holder.getAvailableCookiesField().invoke("get").arg(JExpr.lit(urlVariable));
                methodBody.invoke((JExpression)hashMapVar, "put").arg(urlVariable).arg(cookieValue);
            }
            return hashMapVar;
        }
        return null;
    }

    public String acceptedHeaders(ExecutableElement executableElement) {
        Accept acceptAnnotation = executableElement.getAnnotation(Accept.class);
        if (acceptAnnotation == null) {
            acceptAnnotation = executableElement.getEnclosingElement().getAnnotation(Accept.class);
        }
        if (acceptAnnotation != null) {
            return acceptAnnotation.value();
        }
        return null;
    }

    public String[] requiredHeaders(ExecutableElement executableElement) {
        RequiresHeader cookieAnnotation = executableElement.getAnnotation(RequiresHeader.class);
        if (cookieAnnotation == null) {
            cookieAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresHeader.class);
        }
        if (cookieAnnotation != null) {
            return cookieAnnotation.value();
        }
        return null;
    }

    public String[] requiredCookies(ExecutableElement executableElement) {
        RequiresCookie cookieAnnotation = executableElement.getAnnotation(RequiresCookie.class);
        if (cookieAnnotation == null) {
            cookieAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresCookie.class);
        }
        if (cookieAnnotation != null) {
            return cookieAnnotation.value();
        }
        return null;
    }

    public static String[] requiredUrlCookies(ExecutableElement executableElement) {
        RequiresCookieInUrl cookieAnnotation = executableElement.getAnnotation(RequiresCookieInUrl.class);
        if (cookieAnnotation == null) {
            cookieAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresCookieInUrl.class);
        }
        if (cookieAnnotation != null) {
            return cookieAnnotation.value();
        }
        return null;
    }

    public String[] settingCookies(ExecutableElement executableElement) {
        SetsCookie cookieAnnotation = executableElement.getAnnotation(SetsCookie.class);
        if (cookieAnnotation == null) {
            cookieAnnotation = executableElement.getEnclosingElement().getAnnotation(SetsCookie.class);
        }
        if (cookieAnnotation != null) {
            return cookieAnnotation.value();
        }
        return null;
    }

    public boolean requiredAuthentication(ExecutableElement executableElement) {
        RequiresAuthentication basicAuthAnnotation = executableElement.getAnnotation(RequiresAuthentication.class);
        if (basicAuthAnnotation == null) {
            basicAuthAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresAuthentication.class);
        }
        return basicAuthAnnotation != null;
    }

    public JVar declareHttpHeaders(ExecutableElement executableElement, RestHolder holder, JBlock body) {
        JVar httpHeadersVar = null;
        String mediaType = this.acceptedHeaders(executableElement);
        boolean hasMediaTypeDefined = mediaType != null;
        String[] cookies = this.requiredCookies(executableElement);
        boolean requiresCookies = cookies != null && cookies.length > 0;
        String[] headers = this.requiredHeaders(executableElement);
        boolean requiresHeaders = headers != null && headers.length > 0;
        boolean requiresAuth = this.requiredAuthentication(executableElement);
        if (hasMediaTypeDefined || requiresCookies || requiresHeaders || requiresAuth) {
            httpHeadersVar = body.decl(holder.classes().HTTP_HEADERS, "httpHeaders", JExpr._new(holder.classes().HTTP_HEADERS));
        }
        if (hasMediaTypeDefined) {
            JClass collectionsClass = holder.refClass(CanonicalNameConstants.COLLECTIONS);
            JClass mediaTypeClass = holder.refClass("org.springframework.http.MediaType");
            JInvocation mediaTypeListParam = collectionsClass.staticInvoke("singletonList").arg(mediaTypeClass.staticInvoke("parseMediaType").arg(mediaType));
            body.add(JExpr.invoke((JExpression)httpHeadersVar, "setAccept").arg(mediaTypeListParam));
        }
        if (requiresCookies) {
            JClass stringBuilderClass = holder.classes().STRING_BUILDER;
            JVar cookiesValueVar = body.decl(stringBuilderClass, "cookiesValue", JExpr._new(stringBuilderClass));
            for (String cookie : cookies) {
                JInvocation cookieValue = JExpr.invoke((JExpression)holder.getAvailableCookiesField(), "get").arg(cookie);
                JInvocation cookieFormatted = holder.classes().STRING.staticInvoke("format").arg(String.format("%s=%%s;", cookie)).arg(cookieValue);
                JInvocation appendCookie = JExpr.invoke((JExpression)cookiesValueVar, "append").arg(cookieFormatted);
                body.add(appendCookie);
            }
            JInvocation cookiesToString = cookiesValueVar.invoke("toString");
            body.add(JExpr.invoke((JExpression)httpHeadersVar, "set").arg("Cookie").arg(cookiesToString));
        }
        if (requiresHeaders) {
            for (String header : headers) {
                JInvocation headerValue = JExpr.invoke((JExpression)holder.getAvailableHeadersField(), "get").arg(header);
                body.add(JExpr.invoke((JExpression)httpHeadersVar, "set").arg(header).arg(headerValue));
            }
        }
        if (requiresAuth) {
            body.add(httpHeadersVar.invoke("setAuthorization").arg(holder.getAuthenticationField()));
        }
        return httpHeadersVar;
    }

    public JVar getEntitySentToServer(ExecutableElement element, TreeMap<String, JVar> params) {
        Set<String> urlVariables = this.extractUrlVariableNames(element);
        for (String paramName : params.keySet()) {
            if (urlVariables.contains(paramName)) continue;
            return params.get(paramName);
        }
        return null;
    }

    public JExpression declareHttpEntity(ProcessHolder holder, JBlock body, JVar entitySentToServer, JVar httpHeaders) {
        JType entityType = holder.refClass(Object.class);
        if (entitySentToServer != null && (entityType = entitySentToServer.type()).isPrimitive()) {
            entityType = entityType.boxify();
        }
        JClass httpEntity = holder.classes().HTTP_ENTITY;
        JClass narrowedHttpEntity = httpEntity.narrow(entityType);
        JInvocation newHttpEntityVarCall = JExpr._new(narrowedHttpEntity);
        if (entitySentToServer != null) {
            newHttpEntityVarCall.arg(entitySentToServer);
        }
        if (httpHeaders != null) {
            newHttpEntityVarCall.arg(httpHeaders);
        } else if (entitySentToServer == null) {
            return JExpr._null();
        }
        return body.decl(narrowedHttpEntity, "requestEntity", newHttpEntityVarCall);
    }

    public JExpression getResponseClass(Element element, RestHolder holder) {
        JClass responseClass;
        ExecutableElement executableElement = (ExecutableElement)element;
        JExpression responseClassExpr = JExpr._null();
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType.getKind() != TypeKind.VOID && (responseClass = this.retrieveResponseClass(returnType, holder)) != null) {
            responseClassExpr = responseClass.dotclass();
        }
        return responseClassExpr;
    }

    public JClass retrieveResponseClass(TypeMirror returnType, RestHolder holder) {
        DeclaredType declaredReturnType;
        String returnTypeString = returnType.toString();
        JClass responseClass = returnTypeString.startsWith("org.springframework.http.ResponseEntity") ? ((declaredReturnType = (DeclaredType)returnType).getTypeArguments().size() > 0 ? this.resolveResponseClass(declaredReturnType.getTypeArguments().get(0), holder) : holder.classes().RESPONSE_ENTITY) : this.resolveResponseClass(returnType, holder);
        return responseClass;
    }

    private JClass resolveResponseClass(TypeMirror expectedType, RestHolder holder) {
        if (expectedType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)expectedType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.isEmpty()) {
                return this.codeModelHelper.typeMirrorToJClass(declaredType, holder);
            }
            TypeElement declaredElement = (TypeElement)declaredType.asElement();
            JClass baseClass = this.codeModelHelper.typeMirrorToJClass(declaredType, holder).erasure();
            JClass decoratedExpectedClass = this.retrieveDecoratedResponseClass(declaredType, declaredElement, holder);
            if (decoratedExpectedClass == null) {
                decoratedExpectedClass = baseClass;
            }
            return decoratedExpectedClass;
        }
        if (expectedType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)expectedType;
            return this.resolveResponseClass(arrayType.getComponentType(), holder).array();
        }
        return this.codeModelHelper.typeMirrorToJClass(expectedType, holder);
    }

    /*
     * WARNING - void declaration
     */
    private JClass retrieveDecoratedResponseClass(DeclaredType declaredType, TypeElement typeElement, RestHolder holder) {
        String classTypeBaseName = typeElement.toString();
        String decoratedClassName = null;
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            if (classTypeBaseName.equals(CanonicalNameConstants.MAP)) {
                decoratedClassName = LinkedHashMap.class.getCanonicalName();
            } else if (classTypeBaseName.equals(CanonicalNameConstants.SET)) {
                decoratedClassName = TreeSet.class.getCanonicalName();
            } else if (classTypeBaseName.equals(CanonicalNameConstants.LIST)) {
                decoratedClassName = ArrayList.class.getCanonicalName();
            } else if (classTypeBaseName.equals(CanonicalNameConstants.COLLECTION)) {
                decoratedClassName = ArrayList.class.getCanonicalName();
            }
        } else {
            decoratedClassName = typeElement.getQualifiedName().toString();
        }
        if (decoratedClassName != null) {
            String decoratedClassNameSuffix = "";
            JClass decoratedSuperClass = holder.refClass(decoratedClassName);
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                void var9_11;
                if (typeMirror instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)typeMirror;
                    if (wildcardType.getExtendsBound() != null) {
                        TypeMirror typeMirror2 = wildcardType.getExtendsBound();
                    } else if (wildcardType.getSuperBound() != null) {
                        TypeMirror typeMirror3 = wildcardType.getSuperBound();
                    }
                }
                JClass narrowJClass = this.codeModelHelper.typeMirrorToJClass((TypeMirror)var9_11, holder);
                decoratedSuperClass = decoratedSuperClass.narrow(narrowJClass);
                decoratedClassNameSuffix = decoratedClassNameSuffix + this.plainName(narrowJClass);
            }
            String decoratedFinalClassName = classTypeBaseName + "_" + decoratedClassNameSuffix;
            decoratedFinalClassName = decoratedFinalClassName.replaceAll("\\[\\]", "s");
            String string = holder.getGeneratedClass()._package().name();
            decoratedFinalClassName = string + "." + decoratedFinalClassName;
            JDefinedClass decoratedJClass = holder.definedClass(decoratedFinalClassName);
            decoratedJClass._extends(decoratedSuperClass);
            return decoratedJClass;
        }
        TypeMirror enclosingSuperJClass = typeElement.getSuperclass();
        if (enclosingSuperJClass != null && enclosingSuperJClass.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredEnclosingSuperJClass = (DeclaredType)enclosingSuperJClass;
            return this.retrieveDecoratedResponseClass(declaredType, (TypeElement)declaredEnclosingSuperJClass.asElement(), holder);
        }
        return null;
    }

    protected String plainName(JClass jClass) {
        String plainName = jClass.erasure().name();
        List<JClass> typeParameters = jClass.getTypeParameters();
        if (typeParameters.size() > 0) {
            plainName = plainName + "_";
            for (JClass typeParameter : typeParameters) {
                plainName = plainName + this.plainName(typeParameter);
            }
        }
        return plainName;
    }
}

