/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.impl;

import net.sf.asterisk.fastagi.AGIChannel;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIReader;
import net.sf.asterisk.fastagi.AGIWriter;
import net.sf.asterisk.fastagi.InvalidCommandSyntaxException;
import net.sf.asterisk.fastagi.InvalidOrUnknownCommandException;
import net.sf.asterisk.fastagi.command.AGICommand;
import net.sf.asterisk.fastagi.command.AnswerCommand;
import net.sf.asterisk.fastagi.command.ChannelStatusCommand;
import net.sf.asterisk.fastagi.command.ExecCommand;
import net.sf.asterisk.fastagi.command.GetDataCommand;
import net.sf.asterisk.fastagi.command.GetFullVariableCommand;
import net.sf.asterisk.fastagi.command.GetOptionCommand;
import net.sf.asterisk.fastagi.command.GetVariableCommand;
import net.sf.asterisk.fastagi.command.HangupCommand;
import net.sf.asterisk.fastagi.command.SayAlphaCommand;
import net.sf.asterisk.fastagi.command.SayDateTimeCommand;
import net.sf.asterisk.fastagi.command.SayDigitsCommand;
import net.sf.asterisk.fastagi.command.SayNumberCommand;
import net.sf.asterisk.fastagi.command.SayPhoneticCommand;
import net.sf.asterisk.fastagi.command.SayTimeCommand;
import net.sf.asterisk.fastagi.command.SetAutoHangupCommand;
import net.sf.asterisk.fastagi.command.SetCallerIdCommand;
import net.sf.asterisk.fastagi.command.SetContextCommand;
import net.sf.asterisk.fastagi.command.SetExtensionCommand;
import net.sf.asterisk.fastagi.command.SetMusicOffCommand;
import net.sf.asterisk.fastagi.command.SetMusicOnCommand;
import net.sf.asterisk.fastagi.command.SetPriorityCommand;
import net.sf.asterisk.fastagi.command.SetVariableCommand;
import net.sf.asterisk.fastagi.command.StreamFileCommand;
import net.sf.asterisk.fastagi.command.WaitForDigitCommand;
import net.sf.asterisk.fastagi.impl.AGIReaderImpl;
import net.sf.asterisk.fastagi.impl.AGIWriterImpl;
import net.sf.asterisk.fastagi.reply.AGIReply;
import net.sf.asterisk.io.SocketConnectionFacade;

public class AGIChannelImpl
implements AGIChannel {
    private AGIWriter agiWriter;
    private AGIReader agiReader;

    public AGIChannelImpl(SocketConnectionFacade socket) {
        this.agiWriter = new AGIWriterImpl(socket);
        this.agiReader = new AGIReaderImpl(socket);
    }

    public AGIChannelImpl(AGIWriter agiWriter, AGIReader agiReader) {
        this.agiWriter = agiWriter;
        this.agiReader = agiReader;
    }

    public synchronized AGIReply sendCommand(AGICommand command) throws AGIException {
        this.agiWriter.sendCommand(command);
        AGIReply reply = this.agiReader.readReply();
        if (reply.getStatus() == 510) {
            throw new InvalidOrUnknownCommandException(command.buildCommand());
        }
        if (reply.getStatus() == 520) {
            throw new InvalidCommandSyntaxException(reply.getSynopsis(), reply.getUsage());
        }
        return reply;
    }

    public void answer() throws AGIException {
        this.sendCommand(new AnswerCommand());
    }

    public void hangup() throws AGIException {
        this.sendCommand(new HangupCommand());
    }

    public void setAutoHangup(int time) throws AGIException {
        this.sendCommand(new SetAutoHangupCommand(time));
    }

    public void setCallerId(String callerId) throws AGIException {
        this.sendCommand(new SetCallerIdCommand(callerId));
    }

    public void playMusicOnHold() throws AGIException {
        this.sendCommand(new SetMusicOnCommand());
    }

    public void playMusicOnHold(String musicOnHoldClass) throws AGIException {
        this.sendCommand(new SetMusicOnCommand(musicOnHoldClass));
    }

    public void stopMusicOnHold() throws AGIException {
        this.sendCommand(new SetMusicOffCommand());
    }

    public int getChannelStatus() throws AGIException {
        AGIReply reply = this.sendCommand(new ChannelStatusCommand());
        return reply.getResultCode();
    }

    public String getData(String file) throws AGIException {
        AGIReply reply = this.sendCommand(new GetDataCommand(file));
        return reply.getResult();
    }

    public String getData(String file, long timeout) throws AGIException {
        AGIReply reply = this.sendCommand(new GetDataCommand(file, timeout));
        return reply.getResult();
    }

    public String getData(String file, long timeout, int maxDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new GetDataCommand(file, timeout, maxDigits));
        return reply.getResult();
    }

    public char getOption(String file, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new GetOptionCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public char getOption(String file, String escapeDigits, int timeout) throws AGIException {
        AGIReply reply = this.sendCommand(new GetOptionCommand(file, escapeDigits, timeout));
        return reply.getResultCodeAsChar();
    }

    public int exec(String application) throws AGIException {
        AGIReply reply = this.sendCommand(new ExecCommand(application));
        return reply.getResultCode();
    }

    public int exec(String application, String options) throws AGIException {
        AGIReply reply = this.sendCommand(new ExecCommand(application, options));
        return reply.getResultCode();
    }

    public void setContext(String context) throws AGIException {
        this.sendCommand(new SetContextCommand(context));
    }

    public void setExtension(String extension) throws AGIException {
        this.sendCommand(new SetExtensionCommand(extension));
    }

    public void setPriority(String priority) throws AGIException {
        this.sendCommand(new SetPriorityCommand(priority));
    }

    public void streamFile(String file) throws AGIException {
        this.sendCommand(new StreamFileCommand(file));
    }

    public char streamFile(String file, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new StreamFileCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayDigits(String digits) throws AGIException {
        this.sendCommand(new SayDigitsCommand(digits));
    }

    public char sayDigits(String digits, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayDigitsCommand(digits, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayNumber(String number) throws AGIException {
        this.sendCommand(new SayNumberCommand(number));
    }

    public char sayNumber(String number, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayNumberCommand(number, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayPhonetic(String text) throws AGIException {
        this.sendCommand(new SayPhoneticCommand(text));
    }

    public char sayPhonetic(String text, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayPhoneticCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayAlpha(String text) throws AGIException {
        this.sendCommand(new SayAlphaCommand(text));
    }

    public char sayAlpha(String text, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayAlphaCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayTime(long time) throws AGIException {
        this.sendCommand(new SayTimeCommand(time));
    }

    public char sayTime(long time, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayTimeCommand(time, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public String getVariable(String name) throws AGIException {
        AGIReply reply = this.sendCommand(new GetVariableCommand(name));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    public void setVariable(String name, String value) throws AGIException {
        this.sendCommand(new SetVariableCommand(name, value));
    }

    public char waitForDigit(int timeout) throws AGIException {
        AGIReply reply = this.sendCommand(new WaitForDigitCommand(timeout));
        return reply.getResultCodeAsChar();
    }

    public String getFullVariable(String name) throws AGIException {
        AGIReply reply = this.sendCommand(new GetFullVariableCommand(name));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    public String getFullVariable(String name, String channel) throws AGIException {
        AGIReply reply = this.sendCommand(new GetFullVariableCommand(name, channel));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    public char sayDateTime(long time, String escapeDigits, String format, String timezone) throws AGIException {
        AGIReply reply = this.sendCommand(new SayDateTimeCommand(time, escapeDigits, format, timezone));
        return reply.getResultCodeAsChar();
    }

    public char sayDateTime(long time, String escapeDigits, String format) throws AGIException {
        AGIReply reply = this.sendCommand(new SayDateTimeCommand(time, escapeDigits, format));
        return reply.getResultCodeAsChar();
    }

    public char sayDateTime(long time, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayDateTimeCommand(time, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    public void sayDateTime(long time) throws AGIException {
        this.sendCommand(new SayDateTimeCommand(time));
    }
}

