/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.io.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import net.sf.asterisk.io.SocketConnectionFacade;

public class SocketConnectionFacadeImpl
implements SocketConnectionFacade {
    private final Socket socket;
    private final BufferedReader reader;
    private final BufferedWriter writer;

    public SocketConnectionFacadeImpl(String host, int port) throws IOException {
        this(host, port, 0);
    }

    public SocketConnectionFacadeImpl(String host, int port, int timeout) throws IOException {
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(host, port), timeout);
        InputStream inputStream = this.socket.getInputStream();
        OutputStream outputStream = this.socket.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    SocketConnectionFacadeImpl(Socket socket) throws IOException {
        this.socket = socket;
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public void write(String s) throws IOException {
        this.writer.write(s);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }
}

