/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.definition.table;

import org.atp.api.Typeable;
import org.atp.spi.TypeableImpl;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.SchemaStatement;
import org.sql.generation.api.grammar.common.TableNameDirect;
import org.sql.generation.api.grammar.definition.table.TableCommitAction;
import org.sql.generation.api.grammar.definition.table.TableContentsSource;
import org.sql.generation.api.grammar.definition.table.TableDefinition;
import org.sql.generation.api.grammar.definition.table.TableScope;
import org.sql.generation.implementation.grammar.common.SQLSyntaxElementBase;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinitionImpl
extends SQLSyntaxElementBase<SchemaStatement, TableDefinition>
implements TableDefinition {
    private final TableCommitAction _commitAction;
    private final TableContentsSource _contents;
    private final TableNameDirect _name;
    private final TableScope _scope;

    public TableDefinitionImpl(SQLProcessorAggregator processor, TableCommitAction commitAction, TableContentsSource contents, TableNameDirect name, TableScope scope) {
        this(processor, TableDefinition.class, commitAction, contents, name, scope);
    }

    protected TableDefinitionImpl(SQLProcessorAggregator processor, Class<? extends TableDefinition> realImplementingType, TableCommitAction commitAction, TableContentsSource contents, TableNameDirect name, TableScope scope) {
        super(processor, realImplementingType);
        NullArgumentException.validateNotNull((String)"Table name", (Object)name);
        NullArgumentException.validateNotNull((String)"Table contents", (Object)contents);
        this._name = name;
        this._contents = contents;
        this._scope = scope;
        this._commitAction = commitAction;
    }

    protected boolean doesEqual(TableDefinition another) {
        return this._name.equals(another.getTableName()) && this._contents.equals(another.getContents()) && TypeableImpl.bothNullOrEquals((Object)this._scope, (Object)another.getTableScope()) && TypeableImpl.bothNullOrEquals((Object)this._commitAction, (Object)another.getCommitAction());
    }

    public Typeable<?> asTypeable() {
        return this;
    }

    public TableCommitAction getCommitAction() {
        return this._commitAction;
    }

    public TableContentsSource getContents() {
        return this._contents;
    }

    public TableNameDirect getTableName() {
        return this._name;
    }

    public TableScope getTableScope() {
        return this._scope;
    }
}

