/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.query;

import org.atp.spi.TypeableImpl;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.query.FromClause;
import org.sql.generation.api.grammar.query.GroupByClause;
import org.sql.generation.api.grammar.query.LimitSpecification;
import org.sql.generation.api.grammar.query.OffsetSpecification;
import org.sql.generation.api.grammar.query.OrderByClause;
import org.sql.generation.api.grammar.query.QuerySpecification;
import org.sql.generation.api.grammar.query.SelectColumnClause;
import org.sql.generation.implementation.grammar.query.QueryExpressionBodyImpl;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySpecificationImpl
extends QueryExpressionBodyImpl<QuerySpecification>
implements QuerySpecification {
    private final SelectColumnClause _select;
    private final FromClause _from;
    private final BooleanExpression _where;
    private final GroupByClause _groupBy;
    private final BooleanExpression _having;
    private final OrderByClause _orderBy;
    private final OffsetSpecification _offset;
    private final LimitSpecification _limit;

    public QuerySpecificationImpl(SQLProcessorAggregator processor, SelectColumnClause select, FromClause from, BooleanExpression where, GroupByClause groupBy, BooleanExpression having, OrderByClause orderBy, OffsetSpecification offset, LimitSpecification limit) {
        this(processor, QuerySpecification.class, select, from, where, groupBy, having, orderBy, offset, limit);
    }

    protected QuerySpecificationImpl(SQLProcessorAggregator processor, Class<? extends QuerySpecification> queryClass, SelectColumnClause select, FromClause from, BooleanExpression where, GroupByClause groupBy, BooleanExpression having, OrderByClause orderBy, OffsetSpecification offset, LimitSpecification limit) {
        super(processor, queryClass);
        NullArgumentException.validateNotNull((String)"select", (Object)select);
        this._select = select;
        this._from = from;
        this._where = where;
        this._groupBy = groupBy;
        this._having = having;
        this._orderBy = orderBy;
        this._offset = offset;
        this._limit = limit;
    }

    public SelectColumnClause getColumns() {
        return this._select;
    }

    public FromClause getFrom() {
        return this._from;
    }

    public BooleanExpression getWhere() {
        return this._where;
    }

    public GroupByClause getGroupBy() {
        return this._groupBy;
    }

    public BooleanExpression getHaving() {
        return this._having;
    }

    public OrderByClause getOrderBy() {
        return this._orderBy;
    }

    public LimitSpecification getLimitSpecification() {
        return this._limit;
    }

    public OffsetSpecification getOffsetSpecification() {
        return this._offset;
    }

    protected boolean doesEqual(QuerySpecification another) {
        return this._select.equals(another.getColumns()) && TypeableImpl.bothNullOrEquals((Object)this._from, (Object)another.getFrom()) && TypeableImpl.bothNullOrEquals((Object)this._where, (Object)another.getWhere()) && TypeableImpl.bothNullOrEquals((Object)this._groupBy, (Object)another.getGroupBy()) && TypeableImpl.bothNullOrEquals((Object)this._having, (Object)another.getHaving()) && TypeableImpl.bothNullOrEquals((Object)this._orderBy, (Object)another.getOrderBy());
    }
}

