/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.java_websocket.util.ThreadCheck;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Issue580Test {
    private static final int NUMBER_OF_TESTS = 10;
    @Parameterized.Parameter
    public int count;
    @Rule
    public ThreadCheck zombies = new ThreadCheck();

    private void runTestScenario(boolean closeBlocking) throws Exception {
        final CountDownLatch countServerDownLatch = new CountDownLatch(1);
        int port = SocketUtil.getAvailablePort();
        WebSocketServer ws = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                countServerDownLatch.countDown();
            }
        };
        ws.start();
        countServerDownLatch.await();
        WebSocketClient clt = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        clt.connectBlocking();
        clt.send("test");
        if (closeBlocking) {
            clt.closeBlocking();
        }
        ws.stop();
        Thread.sleep(100L);
    }

    @Parameterized.Parameters
    public static Collection<Integer[]> data() {
        ArrayList<Integer[]> ret = new ArrayList<Integer[]>(10);
        for (int i = 0; i < 10; ++i) {
            ret.add(new Integer[]{i});
        }
        return ret;
    }

    @Test
    public void runNoCloseBlockingTestScenario() throws Exception {
        this.runTestScenario(false);
    }

    @Test
    public void runCloseBlockingTestScenario() throws Exception {
        this.runTestScenario(true);
    }
}

