/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.mixin.EnabledAccessor;

public class Operation
extends AbstractOperand<Boolean>
implements EnabledAccessor,
Operand<Boolean> {
    private String _operation;

    public Operation(String aOperation, String aDescription) {
        this(aOperation, aOperation, aDescription, null);
    }

    public Operation(String aOperation, String aDescription, Consumer<Operation> aConsumer) {
        this(aOperation, aOperation, aDescription, aConsumer);
    }

    public Operation(String aOperation, String aAlias, String aDescription) {
        this(aOperation, aAlias, aDescription, null);
    }

    public Operation(String aOperation, String aAlias, String aDescription, Consumer<Operation> aConsumer) {
        super(Boolean.class, aAlias, aDescription, aConsumer);
        if (aOperation == null) {
            throw new IllegalArgumentException("The operation argument must not be null!");
        }
        this._operation = aOperation;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getOperation() {
        return this._operation;
    }

    public boolean isEnabled() {
        Boolean theValue = (Boolean)this.getValue();
        if (theValue != null) {
            return theValue;
        }
        return false;
    }

    @Override
    public List<Operand<Boolean>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliContext) throws ArgsSyntaxException {
        boolean hasOperation;
        if (aArgs != null) {
            for (int i = 0; i < aArgs.length; ++i) {
                if (!this.getOperation().equals(aArgs[i])) continue;
                hasOperation = true;
                break;
            }
        } else {
            hasOperation = false;
        }
        if (hasOperation) {
            ArrayList<Operand<Boolean>> theResult = new ArrayList<Operand<Boolean>>();
            theResult.add(this);
            this.setParsedArgs(new String[]{this.getOperation()});
            this.setValue(true);
            this._matchCount = theResult.size();
            return theResult;
        }
        this._exception = new UnknownArgsException(aArgs, "The operation \"" + this.getOperation() + "\" was found in the command line arguments.", (Term)this);
        throw this._exception;
    }

    @Override
    public void reset() {
        super.reset();
        super.setValue(false);
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toOptionEscapeCode() + this.getOperation() + (String)(this.getAlias() != null ? " " + aCliCtx.toArgumentSpec(this) : "") + aCliCtx.toResetEscapeCode();
    }

    @Override
    protected Boolean toType(String aArg) throws ParseArgsException {
        throw new UnsupportedOperationException("*** NOT REQUIRED BY THIS IMPLEMENTATION ***");
    }
}

