/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;

public class XorCondition
extends AbstractCondition
implements Condition {
    public XorCondition(Term ... aArgs) {
        super("Exactly one (XOR) syntax branch must match from the command line arguments.", aArgs);
    }

    protected XorCondition(String aDescription, Term ... aArgs) {
        super(aDescription, aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList<AnyCondition> theOptionals = new ArrayList<AnyCondition>();
        List<Operand<?>> theResult = null;
        Term theResultSyntaxable = null;
        List<Operand<?>> eOperands = null;
        int theMatchCount = this._children.length;
        ArgsSyntaxException theCause = null;
        for (Term eChild : this._children) {
            if (eChild instanceof AnyCondition) {
                theOptionals.add((AnyCondition)eChild);
            }
            try {
                eOperands = theResult != null && eChild instanceof Operand && theResultSyntaxable instanceof Option ? eChild.parseArgs(XorCondition.toArgsDiff(aArgs, theResult), aOptions, aCliCtx) : eChild.parseArgs(aArgs, aOptions, aCliCtx);
                if (eOperands != null && eOperands.isEmpty()) {
                    eOperands = null;
                }
            }
            catch (ArgsSyntaxException e) {
                if (theCause == null) {
                    theCause = e;
                } else {
                    theCause.addSuppressed((Throwable)((Object)e));
                }
                --theMatchCount;
            }
            theResult = XorCondition.removeDuplicates(theResult, eOperands);
            if (theResult != null && eOperands != null) {
                this._exception = new AmbiguousArgsException(aArgs, "More than one syntax branch matched the command line arguments, though exactly one (XOR) syntax branch must match!", (Throwable)((Object)theCause), (Term)this);
                throw this._exception;
            }
            if (eOperands != null && !eOperands.isEmpty() && theResult == null) {
                theResult = eOperands;
                theResultSyntaxable = eChild;
            }
            eOperands = null;
        }
        if (theMatchCount == 0) {
            this._exception = new UnknownArgsException(aArgs, "No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match!", (Throwable)((Object)theCause), (Term)this);
            throw this._exception;
        }
        if (theMatchCount > 1) {
            if (theOptionals.size() > 1 && aArgs != null && aArgs.length > 0) {
                this._exception = new AmbiguousArgsException(aArgs, "No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", (Throwable)((Object)theCause), (Term)this);
                throw this._exception;
            }
            if ((theMatchCount -= theOptionals.size()) > 1) {
                this._exception = new AmbiguousArgsException(aArgs, "No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", (Throwable)((Object)theCause), (Term)this);
                throw this._exception;
            }
        }
        if (theResult != null) {
            return theResult;
        }
        if (theOptionals.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        this._exception = new UnknownArgsException(aArgs, "No syntax branch (fully) matched the provided command line arguments, though one (XOR) syntax branch must match!", (Throwable)((Object)theCause), (Term)this);
        throw this._exception;
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        Object theSynopsis = "";
        for (Term eChild : this._children) {
            if (((String)theSynopsis).length() != 0) {
                theSynopsis = (String)theSynopsis + (String)(aCliCtx.getSyntaxMetrics().getXorSymbol() != null && aCliCtx.getSyntaxMetrics().getXorSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getXorSymbol() + " " : " ");
            }
            theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
        }
        return theSynopsis;
    }

    private static List<Operand<?>> removeDuplicates(List<Operand<?>> aElements, List<Operand<?>> aDuplicates) {
        if (aElements != null && aDuplicates != null) {
            for (Operand<?> eOperand : aDuplicates) {
                if (!aElements.contains(eOperand)) continue;
                aElements.remove(eOperand);
            }
            if (aElements.isEmpty()) {
                aElements = null;
            }
        }
        return aElements;
    }
}

