/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.service.example;

import java.io.File;
import org.rxjava.apikit.tool.ApiGenerateManager;
import org.rxjava.apikit.tool.generator.Generator;
import org.rxjava.apikit.tool.generator.impl.JavaClientApiGenerator;
import org.rxjava.apikit.tool.generator.impl.JavaScriptApiGenerator;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;

public class RxApiBuildApplication
implements CommandLineRunner {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{RxApiBuildApplication.class}).web(WebApplicationType.NONE).run(args);
    }

    public void run(String ... args) throws Exception {
        String moduleAbsolutePath = this.getModuleAbsolutePath("rxjava-example");
        String javaSourceDir = new File(moduleAbsolutePath, "src/main/java/").getAbsolutePath();
        String javaOutPath = new File(moduleAbsolutePath, "src/test/java/").getAbsolutePath();
        String jsOutPath = new File(moduleAbsolutePath, "src/test/js/").getAbsolutePath();
        JavaClientApiGenerator javaClientApiGenerator = new JavaClientApiGenerator();
        javaClientApiGenerator.setOutRootPackage("org.rxjava.api.example");
        javaClientApiGenerator.setOutPath(javaOutPath);
        JavaScriptApiGenerator javaScriptApiGenerator = new JavaScriptApiGenerator();
        javaScriptApiGenerator.setOutPath(jsOutPath);
        javaScriptApiGenerator.setServiceId("example");
        ApiGenerateManager apiGenerateManager = new ApiGenerateManager(javaSourceDir, "org.rxjava.service.example");
        apiGenerateManager.generate((Generator)javaClientApiGenerator);
        apiGenerateManager.generate((Generator)javaScriptApiGenerator);
    }

    private String getModuleAbsolutePath(String module) {
        File root = new File(module);
        if (!root.exists()) {
            root = new File("rxjava/", module);
        }
        if (!root.exists()) {
            root = new File(".");
        }
        return root.getAbsolutePath();
    }
}

