/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Clock {
    REAL_TIME{

        long time() {
            return System.currentTimeMillis();
        }
    }
    ,
    NANO_TIME{

        long time() {
            return System.nanoTime() / 1000000L;
        }
    }
    ,
    CPU_TIME{

        long time() {
            if (mxBean.isThreadCpuTimeSupported()) {
                return mxBean.getCurrentThreadCpuTime() / 1000000L;
            }
            throw new RuntimeException("ThreadCpuTime is not supported. Impossible to use Clock.CPU_TIME");
        }
    }
    ,
    USER_TIME{

        long time() {
            if (mxBean.isThreadCpuTimeSupported()) {
                return mxBean.getCurrentThreadUserTime() / 1000000L;
            }
            throw new RuntimeException("ThreadCpuTime is not supported. Impossible to use Clock.USER_TIME");
        }
    };

    private static final int FACTOR = 1000000;
    private static ThreadMXBean mxBean;

    abstract long time();

    static {
        mxBean = ManagementFactory.getThreadMXBean();
        if (mxBean.isThreadCpuTimeSupported()) {
            mxBean.setThreadCpuTimeEnabled(true);
        }
    }
}

