/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.app.App;
import org.scijava.app.AppService;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultAppService
extends AbstractSingletonService<App>
implements AppService {
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;
    private Map<String, App> apps;

    @Override
    public App getApp() {
        List appList = this.getInstances();
        if (appList == null || appList.isEmpty()) {
            return null;
        }
        return (App)appList.get(0);
    }

    @Override
    public App getApp(String name) {
        return this.apps().get(name);
    }

    @Override
    public Map<String, App> getApps() {
        return this.apps();
    }

    @Override
    public Class<App> getPluginType() {
        return App.class;
    }

    private Map<String, App> apps() {
        if (this.apps == null) {
            this.initApps();
        }
        return this.apps;
    }

    private synchronized void initApps() {
        if (this.apps != null) {
            return;
        }
        HashMap<String, App> map = new HashMap<String, App>();
        for (App app : this.getInstances()) {
            String name = app.getInfo().getName();
            if (map.containsKey(name)) continue;
            map.put(name, app);
        }
        this.apps = Collections.unmodifiableMap(map);
    }
}

