/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.ClassUtils;
import org.scijava.util.ConversionUtils;
import org.scijava.util.LongArray;

public class ConversionUtilsTest {
    @Test
    public void testCanCast() {
        Assert.assertTrue((boolean)ConversionUtils.canCast(String.class, Object.class));
        Assert.assertTrue((boolean)ConversionUtils.canCast(ArrayList.class, Collection.class));
        Assert.assertFalse((boolean)ConversionUtils.canCast(Double.TYPE, Float.TYPE));
        Assert.assertFalse((boolean)ConversionUtils.canCast(Float.TYPE, Double.TYPE));
        Assert.assertFalse((boolean)ConversionUtils.canCast(Integer.TYPE, Number.class));
        Object nullObject = null;
        Assert.assertTrue((boolean)ConversionUtils.canCast(nullObject, Object.class));
        Assert.assertTrue((boolean)ConversionUtils.canCast(nullObject, int[].class));
    }

    @Test
    public void testCanConvert() {
        Assert.assertTrue((boolean)ConversionUtils.canConvert(String.class, Object.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(ArrayList.class, Collection.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(Double.TYPE, Float.TYPE));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(Float.TYPE, Double.TYPE));
        Assert.assertFalse((boolean)ConversionUtils.canConvert(Integer.TYPE, Number.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(Object.class, String.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(String.class, Character.TYPE));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(String.class, Character.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(String.class, Words.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(String.class, Double.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(Collection.class, ArrayList.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(HashSet.class, ArrayList.class));
        Assert.assertTrue((boolean)ConversionUtils.canConvert(Long.TYPE, Date.class));
        Assert.assertFalse((boolean)ConversionUtils.canConvert(Collection.class, List.class));
        Assert.assertFalse((boolean)ConversionUtils.canConvert(Integer.TYPE, Date.class));
    }

    @Test
    public void testCast() {
        String string = "Hello";
        Object stringToObject = ConversionUtils.cast((Object)"Hello", Object.class);
        Assert.assertSame((Object)"Hello", (Object)stringToObject);
        ArrayList arrayList = new ArrayList();
        Collection arrayListToCollection = (Collection)ConversionUtils.cast(arrayList, Collection.class);
        Assert.assertSame(arrayList, (Object)arrayListToCollection);
        Float doubleToFloat = (Float)ConversionUtils.cast((Object)5.1, Float.TYPE);
        Assert.assertNull((Object)doubleToFloat);
        Double floatToDouble = (Double)ConversionUtils.cast((Object)Float.valueOf(5.1f), Double.TYPE);
        Assert.assertNull((Object)floatToDouble);
        Number intToNumber = (Number)ConversionUtils.cast((Object)5, Number.class);
        Assert.assertSame(Integer.class, intToNumber.getClass());
        Assert.assertEquals((long)5L, (long)intToNumber.intValue());
    }

    public void testConvert() {
        String string = "Hello";
        Object stringToObject = ConversionUtils.convert((Object)"Hello", Object.class);
        Assert.assertSame((Object)"Hello", (Object)stringToObject);
        ArrayList arrayList = new ArrayList();
        Collection arrayListToCollection = (Collection)ConversionUtils.convert(arrayList, Collection.class);
        Assert.assertSame(arrayList, (Object)arrayListToCollection);
        Words fubar = (Words)((Object)ConversionUtils.convert((Object)"FUBAR", Words.class));
        Assert.assertSame((Object)((Object)Words.FUBAR), (Object)((Object)fubar));
        Words noConstant = (Words)((Object)ConversionUtils.convert((Object)"NONE", Words.class));
        Assert.assertNull((Object)((Object)noConstant));
        double d = 5.1;
        float doubleToFloat = ((Float)ConversionUtils.convert((Object)5.1, Float.TYPE)).floatValue();
        Assert.assertTrue((5.1f == doubleToFloat ? 1 : 0) != 0);
        float f = 6.2f;
        double floatToDouble = (Double)ConversionUtils.convert(Float.TYPE, Double.TYPE);
        Assert.assertEquals((double)6.2f, (double)floatToDouble, (double)0.0);
        Number intToNumber = (Number)ConversionUtils.convert((Object)5, Number.class);
        Assert.assertSame(Integer.class, intToNumber.getClass());
        Assert.assertEquals((long)5L, (long)intToNumber.intValue());
        Object object = new Object();
        String objectToString = (String)ConversionUtils.convert((Object)object, String.class);
        Assert.assertEquals((Object)object.toString(), (Object)objectToString);
        String name = "Houdini";
        char c = ((Character)ConversionUtils.convert((Object)"Houdini", Character.TYPE)).charValue();
        Assert.assertTrue(("Houdini".charAt(0) == c ? 1 : 0) != 0);
        String ns = "8.7";
        double stringToDouble = (Double)ConversionUtils.convert((Object)"8.7", Double.class);
        Assert.assertEquals((double)8.7, (double)stringToDouble, (double)0.0);
        HashSet<String> set = new HashSet<String>();
        set.add("Foo");
        set.add("Bar");
        ArrayList setToArrayList = (ArrayList)ConversionUtils.convert(set, ArrayList.class);
        Assert.assertEquals((long)2L, (long)setToArrayList.size());
        Collections.sort(setToArrayList);
        Assert.assertEquals((Object)"Bar", setToArrayList.get(0));
        Assert.assertEquals((Object)"Foo", setToArrayList.get(1));
        Date date = new Date();
        long datestamp = date.getTime();
        Date longToDate = (Date)ConversionUtils.convert((Object)datestamp, Date.class);
        Assert.assertEquals((Object)date, (Object)longToDate);
        List setToList = (List)ConversionUtils.convert(set, List.class);
        Assert.assertNull((Object)setToList);
        int intStamp = (int)datestamp;
        Date intToDate = (Date)ConversionUtils.convert((Object)intStamp, Date.class);
        Assert.assertNull((Object)intToDate);
    }

    @Test
    public void testConvertSubclass() {
        HisList hisList = new HisList();
        hisList.add("Foo");
        hisList.add("Bar");
        HerList herList = (HerList)ConversionUtils.convert((Object)hisList, HerList.class);
        Assert.assertEquals((long)2L, (long)herList.size());
        Assert.assertEquals((Object)"Foo", herList.get(0));
        Assert.assertEquals((Object)"Bar", herList.get(1));
        ObjectList objectList = (ObjectList)ConversionUtils.convert((Object)hisList, ObjectList.class);
        Assert.assertEquals((long)2L, (long)objectList.size());
        Assert.assertEquals((Object)"Foo", objectList.get(0));
        Assert.assertEquals((Object)"Bar", objectList.get(1));
        HisList objectToHisList = (HisList)ConversionUtils.convert((Object)objectList, HisList.class);
        Assert.assertEquals((long)2L, (long)objectToHisList.size());
        Assert.assertEquals((Object)"Foo", objectToHisList.get(0));
        Assert.assertEquals((Object)"Bar", objectToHisList.get(1));
        NumberList hisToNumberList = (NumberList)ConversionUtils.convert((Object)hisList, NumberList.class);
        Assert.assertEquals((long)2L, (long)hisToNumberList.size());
        Assert.assertEquals((Object)"Foo", hisToNumberList.get(0));
        Assert.assertEquals((Object)"Bar", hisToNumberList.get(1));
        try {
            Number n0 = (Number)hisToNumberList.get(0);
            Assert.fail((String)("expected ClassCastException but got: " + n0));
        }
        catch (ClassCastException exc) {
            // empty catch block
        }
    }

    @Test
    public void testConvertTypeCasting() {
        class Struct {
            private INumberList iNumberList;
            private List<String> list;

            Struct() {
            }
        }
        Struct struct = new Struct();
        NumberList numberList = new NumberList();
        numberList.add(5);
        this.setFieldValue(struct, "iNumberList", numberList);
        Assert.assertSame((Object)numberList, (Object)struct.iNumberList);
        this.setFieldValue(struct, "list", numberList);
        Assert.assertSame((Object)numberList, (Object)struct.list);
    }

    @Test
    public void testConvertToEnum() {
        Words foo = (Words)((Object)ConversionUtils.convertToEnum((String)"FOO", Words.class));
        Assert.assertSame((Object)((Object)Words.FOO), (Object)((Object)foo));
        Words bar = (Words)((Object)ConversionUtils.convertToEnum((String)"BAR", Words.class));
        Assert.assertSame((Object)((Object)Words.BAR), (Object)((Object)bar));
        Words fubar = (Words)((Object)ConversionUtils.convertToEnum((String)"FUBAR", Words.class));
        Assert.assertSame((Object)((Object)Words.FUBAR), (Object)((Object)fubar));
        Words noConstant = (Words)((Object)ConversionUtils.convertToEnum((String)"NONE", Words.class));
        Assert.assertNull((Object)((Object)noConstant));
        String notAnEnum = (String)ConversionUtils.convertToEnum((String)"HOOYAH", String.class);
        Assert.assertNull((Object)notAnEnum);
    }

    @Test
    public void testGetNonprimitiveType() {
        Class[] types;
        Class booleanType = ConversionUtils.getNonprimitiveType(Boolean.TYPE);
        Assert.assertSame(Boolean.class, (Object)booleanType);
        Class byteType = ConversionUtils.getNonprimitiveType(Byte.TYPE);
        Assert.assertSame(Byte.class, (Object)byteType);
        Class charType = ConversionUtils.getNonprimitiveType(Character.TYPE);
        Assert.assertSame(Character.class, (Object)charType);
        Class doubleType = ConversionUtils.getNonprimitiveType(Double.TYPE);
        Assert.assertSame(Double.class, (Object)doubleType);
        Class floatType = ConversionUtils.getNonprimitiveType(Float.TYPE);
        Assert.assertSame(Float.class, (Object)floatType);
        Class intType = ConversionUtils.getNonprimitiveType(Integer.TYPE);
        Assert.assertSame(Integer.class, (Object)intType);
        Class longType = ConversionUtils.getNonprimitiveType(Long.TYPE);
        Assert.assertSame(Long.class, (Object)longType);
        Class shortType = ConversionUtils.getNonprimitiveType(Short.TYPE);
        Assert.assertSame(Short.class, (Object)shortType);
        Class voidType = ConversionUtils.getNonprimitiveType(Void.TYPE);
        Assert.assertSame(Void.class, (Object)voidType);
        for (Class c : types = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class, Number.class, BigInteger.class, BigDecimal.class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Void[].class, Object.class, Object[].class, String[].class, Object[][].class, String[][].class, Collection.class, List.class, ArrayList.class, LinkedList.class, Set.class, HashSet.class, Map.class, HashMap.class, Collection[].class, List[].class, Set[].class, Map[].class}) {
            Class type = ConversionUtils.getNonprimitiveType((Class)c);
            Assert.assertSame((Object)c, (Object)type);
        }
    }

    @Test
    public void testGetNullValue() {
        Class[] types;
        boolean booleanNull = (Boolean)ConversionUtils.getNullValue(Boolean.TYPE);
        Assert.assertFalse((boolean)booleanNull);
        byte byteNull = (Byte)ConversionUtils.getNullValue(Byte.TYPE);
        Assert.assertEquals((long)0L, (long)byteNull);
        char charNull = ((Character)ConversionUtils.getNullValue(Character.TYPE)).charValue();
        Assert.assertEquals((long)0L, (long)charNull);
        double doubleNull = (Double)ConversionUtils.getNullValue(Double.TYPE);
        Assert.assertEquals((double)0.0, (double)doubleNull, (double)0.0);
        float floatNull = ((Float)ConversionUtils.getNullValue(Float.TYPE)).floatValue();
        Assert.assertEquals((float)0.0f, (float)floatNull, (float)0.0f);
        int intNull = (Integer)ConversionUtils.getNullValue(Integer.TYPE);
        Assert.assertEquals((long)0L, (long)intNull);
        long longNull = (Long)ConversionUtils.getNullValue(Long.TYPE);
        Assert.assertEquals((long)0L, (long)longNull);
        short shortNull = (Short)ConversionUtils.getNullValue(Short.TYPE);
        Assert.assertEquals((long)0L, (long)shortNull);
        Void voidNull = (Void)ConversionUtils.getNullValue(Void.TYPE);
        Assert.assertNull((Object)voidNull);
        for (Class c : types = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class, Number.class, BigInteger.class, BigDecimal.class, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class, Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Void[].class, Object.class, Object[].class, String[].class, Object[][].class, String[][].class, Collection.class, List.class, ArrayList.class, LinkedList.class, Set.class, HashSet.class, Map.class, HashMap.class, Collection[].class, List[].class, Set[].class, Map[].class}) {
            Object nullValue = ConversionUtils.getNullValue((Class)c);
            Assert.assertNull((String)("Expected null for " + c.getName()), (Object)nullValue);
        }
    }

    @Test
    public void testPrimitiveArray() {
        int i;
        class Struct {
            private int[] intArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        List<Integer> intVals = this.getValueList(4, 3, 7);
        this.setFieldValue(struct, "intArray", intVals);
        for (i = 0; i < struct.intArray.length; ++i) {
            Assert.assertEquals((long)intVals.get(i).intValue(), (long)struct.intArray[i]);
        }
        this.setFieldValue(struct, "intArray", new int[]{8, 6, 14});
        for (i = 0; i < struct.intArray.length; ++i) {
            Assert.assertEquals((long)(intVals.get(i) * 2), (long)struct.intArray[i]);
        }
    }

    @Test
    public void testObjectArray() {
        class Struct {
            private Double[] doubleArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        List<Double> doubleVals = this.getValueList(1.0, 2.0, 3.0);
        this.setFieldValue(struct, "doubleArray", doubleVals);
        for (int i = 0; i < struct.doubleArray.length; ++i) {
            Assert.assertEquals((Object)doubleVals.get(i), (Object)struct.doubleArray[i]);
        }
    }

    @Test
    public void testCollection() {
        int i;
        class Struct {
            private List<String> stringList;

            Struct() {
            }
        }
        Struct struct = new Struct();
        List<String> stringVals = this.getValueList("ok", "still ok");
        this.setFieldValue(struct, "stringList", stringVals);
        for (i = 0; i < struct.stringList.size(); ++i) {
            Assert.assertEquals((Object)stringVals.get(i), struct.stringList.get(i));
        }
        this.setFieldValue(struct, "stringList", stringVals.toArray());
        for (i = 0; i < struct.stringList.size(); ++i) {
            Assert.assertEquals((Object)stringVals.get(i), struct.stringList.get(i));
        }
    }

    @Test
    public void testFromCollectionSubclass() {
        class Struct {
            private List<String> stringList;

            Struct() {
            }
        }
        Struct struct = new Struct();
        class RandomSet
        extends HashSet<Random> {
            RandomSet() {
            }
        }
        RandomSet randomSet = new RandomSet();
        randomSet.add(new Random(567L));
        randomSet.add(new Random(321L));
        this.setFieldValue(struct, "stringList", randomSet);
        Assert.assertNotNull((Object)struct.stringList);
        Assert.assertEquals((long)2L, (long)struct.stringList.size());
        for (String s : struct.stringList) {
            Assert.assertTrue((boolean)s.matches("^java.util.Random@[0-9a-f]+$"));
        }
    }

    @Test
    public void testToCollectionSubclass() {
        class Struct {
            private ListExtension<Double> myDoubles;
            private StringListExtension myStrings;

            Struct() {
            }
        }
        Struct struct = new Struct();
        LongArray longArray = new LongArray();
        longArray.add((Object)123456789012L);
        longArray.add((Object)987654321098L);
        this.setFieldValue(struct, "myDoubles", longArray);
        Assert.assertNotNull((Object)struct.myDoubles);
        Assert.assertEquals((long)2L, (long)struct.myDoubles.size());
        Assert.assertEquals((double)1.23456789012E11, (double)((Double)struct.myDoubles.get(0)), (double)0.0);
        Assert.assertEquals((double)9.87654321098E11, (double)((Double)struct.myDoubles.get(1)), (double)0.0);
        this.setFieldValue(struct, "myStrings", longArray);
        Assert.assertNull((Object)struct.myStrings);
    }

    @Test
    public void testNestingMultiElements() {
        class Struct {
            private Set<char[]> nestedArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        HashSet<char[]> nestedSetValues = new HashSet<char[]>();
        char[] chars = new char[]{'a', 'b', 'c'};
        nestedSetValues.add(chars);
        this.setFieldValue(struct, "nestedArray", nestedSetValues);
        for (char[] charVals : struct.nestedArray) {
            for (int i = 0; i < chars.length; ++i) {
                Assert.assertEquals((long)chars[i], (long)charVals[i]);
            }
        }
    }

    @Test
    public void testSettingSingleElements() {
        class Struct {
            private Double[] doubleArray;
            private List<String> stringList;

            Struct() {
            }
        }
        Struct struct = new Struct();
        double dVal = 6.3;
        this.setFieldValue(struct, "doubleArray", 6.3);
        Assert.assertEquals((Object)new Double(6.3), (Object)struct.doubleArray[0]);
        String sVal = "I am a ghost";
        this.setFieldValue(struct, "stringList", "I am a ghost");
        Assert.assertEquals((Object)"I am a ghost", struct.stringList.get(0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadPrimitiveArray() {
        class Struct {
            private int[] intArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "intArray", "not an int array");
    }

    @Test
    public void testBadObjectElements() {
        class Struct {
            private Double[] doubleArray;
            private List<String> stringList;
            private Set<char[]> nestedArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "doubleArray", "not a double array");
        Assert.assertEquals(null, (Object)struct.doubleArray[0]);
        this.setFieldValue(struct, "nestedArray", "definitely not a set of char arrays");
        Assert.assertNull((Object)struct.stringList);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadSingleton() {
        class Struct {
            private int singleValue;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "singleValue", new int[]{4, 8, 2});
    }

    @Test
    public void testLegitimateSingletonArray() {
        class Struct {
            private ArrayWrapper arrayWrapper;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "arrayWrapper", new int[]{4, 8, 2});
        Assert.assertNotNull((Object)struct.arrayWrapper);
    }

    @Test
    public void testLegitimateSingletonCollection() {
        class Struct {
            private ListWrapper listWrapper;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "listWrapper", this.getValueList(4, 8, 2));
        Assert.assertNotNull((Object)struct.listWrapper);
    }

    private void setFieldValue(Object o, String fieldName, Object value) {
        ClassUtils.setValue((Field)ClassUtils.getField(o.getClass(), (String)fieldName), (Object)o, (Object)value);
    }

    private <T> List<T> getValueList(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        for (T value : values) {
            list.add(value);
        }
        return list;
    }

    public static enum Words {
        FOO,
        BAR,
        FUBAR;

    }

    public static class StringListExtension
    extends ArrayList<String> {
    }

    public static class ListExtension<T>
    extends ArrayList<T> {
    }

    private static class ListWrapper {
        public ListWrapper(List<?> gonnaWrapThisList) {
        }
    }

    private static class ArrayWrapper {
        public ArrayWrapper(int[] gonnaWrapThisArray) {
        }
    }

    private static interface INumberList
    extends List<Number> {
    }

    private static class NumberList
    extends ArrayList<Number>
    implements INumberList {
        public NumberList() {
        }

        public NumberList(Collection<? extends Number> c) {
            super(c);
        }
    }

    private static class ObjectList
    extends ArrayList<Object> {
        public ObjectList(Collection<? extends Object> c) {
            super(c);
        }
    }

    private static class HerList
    extends ArrayList<String> {
        public HerList(Collection<? extends String> c) {
            super(c);
        }
    }

    private static class HisList
    extends ArrayList<String> {
        public HisList() {
        }

        public HisList(Collection<? extends String> c) {
            super(c);
        }
    }
}

