/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.scijava.log.LogService;
import org.scijava.service.AbstractService;

public abstract class AbstractLogService
extends AbstractService
implements LogService {
    private int currentLevel = System.getenv("DEBUG") == null ? 2 : 4;
    private Map<String, Integer> classAndPackageLevels = new HashMap<String, Integer>();

    protected abstract void log(String var1);

    protected abstract void log(Throwable var1);

    public AbstractLogService() {
        String logProp = System.getProperty("scijava.log.level");
        int level = this.level(logProp);
        if (level >= 0) {
            this.setLevel(level);
        }
        if (this.getLevel() == 0) {
            this.setLevel(System.getenv("DEBUG") == null ? 2 : 4);
        }
        String logLevelPrefix = "scijava.log.level:";
        Properties props = System.getProperties();
        for (Object propKey : props.keySet()) {
            String propName;
            if (!(propKey instanceof String) || !(propName = (String)propKey).startsWith("scijava.log.level:")) continue;
            String classOrPackageName = propName.substring("scijava.log.level:".length());
            this.setLevel(classOrPackageName, this.level(props.getProperty(propName)));
        }
    }

    protected void log(int level, Object msg, Throwable t) {
        if (level > this.getLevel()) {
            return;
        }
        if (msg != null || t == null) {
            this.log(level, msg);
        }
        if (t != null) {
            this.log(t);
        }
    }

    protected void log(int level, Object msg) {
        String prefix = this.getPrefix(level);
        this.log((prefix == null ? "" : prefix + " ") + msg);
    }

    protected String getPrefix(int level) {
        switch (level) {
            case 1: {
                return "[ERROR]";
            }
            case 2: {
                return "[WARNING]";
            }
            case 3: {
                return "[INFO]";
            }
            case 4: {
                return "[DEBUG]";
            }
            case 5: {
                return "[TRACE]";
            }
        }
        return null;
    }

    @Override
    public void debug(Object msg) {
        this.log(4, msg, null);
    }

    @Override
    public void debug(Throwable t) {
        this.log(4, null, t);
    }

    @Override
    public void debug(Object msg, Throwable t) {
        this.log(4, msg, t);
    }

    @Override
    public void error(Object msg) {
        this.log(1, msg, null);
    }

    @Override
    public void error(Throwable t) {
        this.log(1, null, t);
    }

    @Override
    public void error(Object msg, Throwable t) {
        this.log(1, msg, t);
    }

    @Override
    public void info(Object msg) {
        this.log(3, msg, null);
    }

    @Override
    public void info(Throwable t) {
        this.log(3, null, t);
    }

    @Override
    public void info(Object msg, Throwable t) {
        this.log(3, msg, t);
    }

    @Override
    public void trace(Object msg) {
        this.log(5, msg, null);
    }

    @Override
    public void trace(Throwable t) {
        this.log(5, null, t);
    }

    @Override
    public void trace(Object msg, Throwable t) {
        this.log(5, msg, t);
    }

    @Override
    public void warn(Object msg) {
        this.log(2, msg, null);
    }

    @Override
    public void warn(Throwable t) {
        this.log(2, null, t);
    }

    @Override
    public void warn(Object msg, Throwable t) {
        this.log(2, msg, t);
    }

    @Override
    public boolean isDebug() {
        return this.getLevel() >= 4;
    }

    @Override
    public boolean isError() {
        return this.getLevel() >= 1;
    }

    @Override
    public boolean isInfo() {
        return this.getLevel() >= 3;
    }

    @Override
    public boolean isTrace() {
        return this.getLevel() >= 5;
    }

    @Override
    public boolean isWarn() {
        return this.getLevel() >= 2;
    }

    @Override
    public int getLevel() {
        if (!this.classAndPackageLevels.isEmpty()) {
            String classOrPackageName = this.callingClass();
            while (classOrPackageName != null) {
                Integer level = this.classAndPackageLevels.get(classOrPackageName);
                if (level != null) {
                    return level;
                }
                classOrPackageName = this.parentPackage(classOrPackageName);
            }
        }
        return this.currentLevel;
    }

    @Override
    public void setLevel(int level) {
        this.currentLevel = level;
    }

    public void setLevel(String classOrPackageName, int level) {
        this.classAndPackageLevels.put(classOrPackageName, level);
    }

    private int level(String logProp) {
        if (logProp == null) {
            return -1;
        }
        String log = logProp.trim().toLowerCase();
        if (log.startsWith("n")) {
            return 0;
        }
        if (log.startsWith("e")) {
            return 1;
        }
        if (log.startsWith("w")) {
            return 2;
        }
        if (log.startsWith("i")) {
            return 3;
        }
        if (log.startsWith("d")) {
            return 4;
        }
        if (log.startsWith("t")) {
            return 5;
        }
        try {
            return Integer.parseInt(log);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String callingClass() {
        String thisClass = AbstractLogService.class.getName();
        for (StackTraceElement element : new Exception().getStackTrace()) {
            String className = element.getClassName();
            if (thisClass.equals(className)) continue;
            return className;
        }
        return null;
    }

    private String parentPackage(String classOrPackageName) {
        int dot = classOrPackageName.lastIndexOf(".");
        if (dot < 0) {
            return null;
        }
        return classOrPackageName.substring(0, dot);
    }
}

