/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.widget;

import java.util.Arrays;
import java.util.List;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.ItemVisibility;
import org.scijava.log.LogService;
import org.scijava.module.MethodCallException;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;
import org.scijava.util.ClassUtils;
import org.scijava.util.ConversionUtils;
import org.scijava.util.MiscUtils;
import org.scijava.util.NumberUtils;
import org.scijava.widget.InputPanel;

public class WidgetModel
extends AbstractContextual {
    private final InputPanel<?, ?> inputPanel;
    private final Module module;
    private final ModuleItem<?> item;
    private final List<?> objectPool;
    @Parameter
    private ThreadService threadService;
    @Parameter(required=false)
    private LogService log;
    private boolean initialized;

    public WidgetModel(Context context, InputPanel<?, ?> inputPanel, Module module, ModuleItem<?> item, List<?> objectPool) {
        this.setContext(context);
        this.inputPanel = inputPanel;
        this.module = module;
        this.item = item;
        this.objectPool = objectPool;
    }

    public InputPanel<?, ?> getPanel() {
        return this.inputPanel;
    }

    public Module getModule() {
        return this.module;
    }

    public ModuleItem<?> getItem() {
        return this.item;
    }

    public List<?> getObjectPool() {
        return this.objectPool;
    }

    public String getWidgetLabel() {
        String label = this.item.getLabel();
        if (label != null && !label.isEmpty()) {
            return label;
        }
        String name = this.item.getName();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public boolean isStyle(String style) {
        String widgetStyle = this.getItem().getWidgetStyle();
        if (widgetStyle == null) {
            return style == null;
        }
        for (String s : widgetStyle.split(",")) {
            if (!s.equals(style)) continue;
            return true;
        }
        return false;
    }

    public Object getValue() {
        Object value = this.item.getValue(this.module);
        if (this.isMultipleChoice()) {
            return this.ensureValidChoice(value);
        }
        if (this.getObjectPool().size() > 0) {
            return this.ensureValidObject(value);
        }
        return value;
    }

    public void setValue(Object value) {
        String name = this.item.getName();
        if (MiscUtils.equal(this.item.getValue(this.module), value)) {
            return;
        }
        this.module.setInput(name, value);
        if (this.initialized) {
            this.threadService.run(new Runnable(){

                @Override
                public void run() {
                    WidgetModel.this.callback();
                    WidgetModel.this.inputPanel.refresh();
                    WidgetModel.this.module.preview();
                }
            });
        }
    }

    public void callback() {
        block2: {
            try {
                this.item.callback(this.module);
            }
            catch (MethodCallException exc) {
                if (this.log == null) break block2;
                this.log.error(exc);
            }
        }
    }

    public Number getMin() {
        Number min = this.toNumber(this.item.getMinimumValue());
        if (min != null) {
            return min;
        }
        return NumberUtils.getMinimumNumber(this.item.getType());
    }

    public Number getMax() {
        Number max = this.toNumber(this.item.getMaximumValue());
        if (max != null) {
            return max;
        }
        return NumberUtils.getMaximumNumber(this.item.getType());
    }

    public Number getSoftMin() {
        Number softMin = this.toNumber(this.item.getSoftMinimum());
        if (softMin != null) {
            return softMin;
        }
        return this.getMin();
    }

    public Number getSoftMax() {
        Number softMax = this.toNumber(this.item.getSoftMaximum());
        if (softMax != null) {
            return softMax;
        }
        return this.getMax();
    }

    public Number getStepSize() {
        Number stepSize = this.toNumber(this.item.getStepSize());
        if (stepSize != null) {
            return stepSize;
        }
        return NumberUtils.toNumber("1", this.item.getType());
    }

    public String[] getChoices() {
        List<?> choicesList = this.item.getChoices();
        String[] choices = new String[choicesList.size()];
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = choicesList.get(i).toString();
        }
        return choices;
    }

    public String getText() {
        Object value = this.getValue();
        if (value == null) {
            return "";
        }
        String text = value.toString();
        if (text.equals("\u0000")) {
            return "";
        }
        return text;
    }

    public boolean isMessage() {
        return this.getItem().getVisibility() == ItemVisibility.MESSAGE;
    }

    public boolean isText() {
        return ClassUtils.isText(this.getItem().getType());
    }

    public boolean isCharacter() {
        return ClassUtils.isCharacter(this.getItem().getType());
    }

    public boolean isNumber() {
        return ClassUtils.isNumber(this.getItem().getType());
    }

    public boolean isBoolean() {
        return ClassUtils.isBoolean(this.getItem().getType());
    }

    public boolean isMultipleChoice() {
        List<?> choices = this.item.getChoices();
        return choices != null && !choices.isEmpty();
    }

    public boolean isType(Class<?> type) {
        return type.isAssignableFrom(this.getItem().getType());
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private Object ensureValidChoice(Object value) {
        return this.ensureValid(value, Arrays.asList(this.getChoices()));
    }

    private Object ensureValidObject(Object value) {
        return this.ensureValid(value, this.getObjectPool());
    }

    private Object ensureValid(Object value, List<?> list) {
        for (Object o : list) {
            if (!o.equals(value)) continue;
            return value;
        }
        Object validValue = list.get(0);
        this.setValue(validValue);
        return validValue;
    }

    private Number toNumber(Object value) {
        Class<?> type = this.item.getType();
        Class<?> saneType = ConversionUtils.getNonprimitiveType(type);
        return NumberUtils.toNumber(value, saneType);
    }
}

