/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.scijava.Versioned;
import org.scijava.util.AppUtils;
import org.scijava.util.ClassUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.IteratorPlus;
import org.scijava.util.XML;
import org.xml.sax.SAXException;

public class POM
extends XML
implements Comparable<POM>,
Versioned {
    private String version;

    public POM(File file) throws ParserConfigurationException, SAXException, IOException {
        super(file);
    }

    public POM(URL url) throws ParserConfigurationException, SAXException, IOException {
        super(url);
    }

    public POM(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        super(in);
    }

    public POM(String s) throws ParserConfigurationException, SAXException, IOException {
        super(s);
    }

    public String getGroupId() {
        String groupId = this.cdata("//project/groupId");
        if (groupId != null) {
            return groupId;
        }
        return this.cdata("//project/parent/groupId");
    }

    public String getArtifactId() {
        return this.cdata("//project/artifactId");
    }

    public String getProjectName() {
        return this.cdata("//project/name");
    }

    public String getProjectDescription() {
        return this.cdata("//project/description");
    }

    public String getProjectURL() {
        return this.cdata("//project/url");
    }

    public String getProjectInceptionYear() {
        return this.cdata("//project/inceptionYear");
    }

    public String getOrganizationName() {
        return this.cdata("//project/organization/name");
    }

    public String getOrganizationURL() {
        return this.cdata("//project/organization/url");
    }

    @Override
    public int compareTo(POM pom) {
        int gid = this.getGroupId().compareTo(pom.getGroupId());
        if (gid != 0) {
            return gid;
        }
        int aid = this.getArtifactId().compareTo(pom.getArtifactId());
        if (aid != 0) {
            return aid;
        }
        return POM.compareVersions(this.getVersion(), pom.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        if (this.version == null) {
            POM pOM = this;
            synchronized (pOM) {
                if (this.version == null) {
                    this.version = this.cdata("//project/version");
                    if (this.version == null) {
                        this.version = this.cdata("//project/parent/version");
                    }
                }
            }
        }
        return this.version;
    }

    public static POM getPOM(Class<?> c, String groupId, String artifactId) {
        try {
            URL location = ClassUtils.getLocation(c);
            if (!location.getProtocol().equals("file") || location.toString().endsWith(".jar")) {
                String pomPath = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml";
                URL pomURL = new URL("jar:" + location.toString() + "!/" + pomPath);
                return new POM(pomURL);
            }
            File file = FileUtils.urlToFile(location);
            File baseDir = AppUtils.getBaseDirectory(file, null);
            File pomFile = new File(baseDir, "pom.xml");
            return new POM(pomFile);
        }
        catch (IOException e) {
            return null;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }

    public static List<POM> getAllPOMs() {
        Enumeration<URL> resources;
        String pomPrefix = "META-INF/maven/";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            resources = classLoader.getResources("META-INF/maven/");
        }
        catch (IOException exc) {
            return null;
        }
        ArrayList<POM> poms = new ArrayList<POM>();
        for (URL resource : new IteratorPlus<URL>(resources)) {
            for (URL url : FileUtils.listContents(resource)) {
                if (!url.getPath().endsWith("/pom.xml")) continue;
                try {
                    poms.add(new POM(url));
                }
                catch (IOException exc) {
                }
                catch (ParserConfigurationException exc) {
                }
                catch (SAXException exc) {}
            }
        }
        return poms;
    }

    public static int compareVersions(String v1, String v2) {
        String[] t1 = v1.split("[^\\w]");
        String[] t2 = v2.split("[^\\w]");
        int size = Math.min(t1.length, t2.length);
        for (int i = 0; i < size; ++i) {
            try {
                long n1 = Long.parseLong(t1[i]);
                long n2 = Long.parseLong(t2[i]);
                if (n1 < n2) {
                    return -1;
                }
                if (n1 <= n2) continue;
                return 1;
            }
            catch (NumberFormatException exc) {
                int result = t1[i].compareTo(t2[i]);
                if (result == 0) continue;
                return result;
            }
        }
        if (t1.length == t2.length) {
            return 0;
        }
        if (v1.startsWith(v2) && v1.charAt(v2.length()) == '-') {
            return -1;
        }
        if (v2.startsWith(v1) && v2.charAt(v1.length()) == '-') {
            return 1;
        }
        return t1.length < t2.length ? -1 : 1;
    }
}

