/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.util.ConversionUtils;

public abstract class AbstractConvertService
extends AbstractHandlerService<ConversionRequest, Converter<?, ?>>
implements ConvertService {
    @Override
    public Class<Converter<?, ?>> getPluginType() {
        return Converter.class;
    }

    @Override
    public Class<ConversionRequest> getType() {
        return ConversionRequest.class;
    }

    @Override
    public Converter<?, ?> getHandler(Object src, Class<?> dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    @Override
    public Converter<?, ?> getHandler(Class<?> src, Class<?> dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    @Override
    public Converter<?, ?> getHandler(Object src, Type dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    @Override
    public Converter<?, ?> getHandler(Class<?> src, Type dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    @Override
    public boolean supports(Object src, Class<?> dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    @Override
    public boolean supports(Class<?> src, Class<?> dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    @Override
    public boolean supports(Object src, Type dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    @Override
    public boolean supports(Class<?> src, Type dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    @Override
    public Collection<Object> getCompatibleInputs(Class<?> dest) {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        for (Converter c : this.getInstances()) {
            if (!dest.isAssignableFrom(c.getOutputType())) continue;
            c.populateInputCandidates(objects);
        }
        return objects;
    }

    @Override
    public Object convert(Object src, Type dest) {
        return this.convert(new ConversionRequest(src, dest));
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        Converter<?, ?> handler = this.getHandler(src, dest);
        return handler == null ? null : (T)handler.convert(src, dest);
    }

    @Override
    public Object convert(ConversionRequest request) {
        Converter handler = (Converter)this.getHandler(request);
        return handler == null ? null : handler.convert(request);
    }

    @Override
    public Collection<Class<?>> getCompatibleInputClasses(Class<?> dest) {
        HashSet compatibleClasses = new HashSet();
        for (Converter converter : this.getInstances()) {
            this.addIfMatches(dest, converter.getOutputType(), converter.getInputType(), compatibleClasses);
        }
        return compatibleClasses;
    }

    @Override
    public Collection<Class<?>> getCompatibleOutputClasses(Class<?> source) {
        HashSet compatibleClasses = new HashSet();
        for (Converter converter : this.getInstances()) {
            this.addIfMatches(source, converter.getInputType(), converter.getOutputType(), compatibleClasses);
        }
        return compatibleClasses;
    }

    @Override
    public void initialize() {
        ConversionUtils.setDelegateService(this, this.getPriority());
    }

    private void addIfMatches(Class<?> c1, Class<?> c2, Class<?> toAdd, Set<Class<?>> classes) {
        if (c1 == c2) {
            classes.add(toAdd);
        }
    }
}

