/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.scijava.io.handle.DataHandleInputStream;
import org.scijava.io.handle.DataHandles;
import org.scijava.io.location.Location;
import org.scijava.plugin.WrapperPlugin;

public interface DataHandle<L extends Location>
extends WrapperPlugin<L>,
DataInput,
DataOutput,
Closeable {
    public static final int DEFAULT_BLOCK_SIZE = 262144;
    public static final int MAX_SEARCH_SIZE = 0x20000000;

    public boolean isReadable();

    public boolean isWritable();

    public boolean exists() throws IOException;

    default public Date lastModified() throws IOException {
        return null;
    }

    default public String checksum() throws IOException {
        return null;
    }

    public long offset() throws IOException;

    public void seek(long var1) throws IOException;

    public long length() throws IOException;

    public void setLength(long var1) throws IOException;

    default public long available(long count) throws IOException {
        long remain = this.length() - this.offset();
        return remain < count ? remain : count;
    }

    default public void ensureReadable(long count) throws IOException {
        if (!this.isReadable()) {
            throw new IOException("This handle is write-only.");
        }
        if (this.available(count) < count) {
            throw new EOFException();
        }
    }

    default public boolean ensureWritable(long count) throws IOException {
        if (!this.isWritable()) {
            throw new IOException("This handle is read-only.");
        }
        long minLength = this.offset() + count;
        if (this.length() < minLength) {
            this.setLength(minLength);
            return false;
        }
        return true;
    }

    public ByteOrder getOrder();

    public void setOrder(ByteOrder var1);

    default public boolean isBigEndian() {
        return this.getOrder() == ByteOrder.BIG_ENDIAN;
    }

    default public boolean isLittleEndian() {
        return this.getOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    default public void setLittleEndian(boolean little) {
        this.setOrder(little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    public String getEncoding();

    public void setEncoding(String var1);

    default public String readCString() throws IOException {
        String line = this.findString("\u0000");
        return line.length() == 0 ? null : line;
    }

    default public String readString(int n) throws IOException {
        int r = (int)this.available(n);
        byte[] b = new byte[r];
        this.readFully(b);
        return new String(b, this.getEncoding());
    }

    default public String readString(String lastChars) throws IOException {
        if (lastChars.length() == 1) {
            return this.findString(lastChars);
        }
        String[] terminators = new String[lastChars.length()];
        for (int i = 0; i < terminators.length; ++i) {
            terminators[i] = lastChars.substring(i, i + 1);
        }
        return this.findString(terminators);
    }

    default public String findString(String ... terminators) throws IOException {
        return this.findString(true, 262144, terminators);
    }

    default public String findString(boolean saveString, String ... terminators) throws IOException {
        return this.findString(saveString, 262144, terminators);
    }

    default public String findString(int blockSize, String ... terminators) throws IOException {
        return this.findString(true, blockSize, terminators);
    }

    default public String findString(boolean saveString, int blockSize, String ... terminators) throws IOException {
        int r;
        boolean tooLong;
        StringBuilder out = new StringBuilder();
        long startPos = this.offset();
        long bytesDropped = 0L;
        long inputLen = this.length();
        long maxLen = inputLen - startPos;
        boolean bl = tooLong = saveString && maxLen > 0x20000000L;
        if (tooLong) {
            maxLen = 0x20000000L;
        }
        boolean match = false;
        int maxTermLen = 0;
        for (String term : terminators) {
            int len = term.length();
            if (len <= maxTermLen) continue;
            maxTermLen = len;
        }
        InputStreamReader in = new InputStreamReader(new DataHandleInputStream(this), this.getEncoding());
        char[] buf = new char[blockSize];
        for (long loc = 0L; loc < maxLen && this.offset() < this.length() - 1L; loc += (long)r) {
            int outLen;
            if (!saveString && (outLen = out.length()) >= maxTermLen) {
                int dropIndex = outLen - maxTermLen + 1;
                String last = out.substring(dropIndex, outLen);
                out.setLength(0);
                out.append(last);
                bytesDropped += (long)dropIndex;
            }
            if ((r = in.read(buf, 0, blockSize)) <= 0) {
                throw new IOException("Cannot read from stream: " + r);
            }
            out.append(buf, 0, r);
            int min = Integer.MAX_VALUE;
            int tagLen = 0;
            String[] stringArray = terminators;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String t;
                int len = (t = stringArray[i]).length();
                int start = (int)(loc - bytesDropped - (long)len);
                int value = out.indexOf(t, start < 0 ? 0 : start);
                if (value < 0 || value >= min) continue;
                match = true;
                min = value;
                tagLen = len;
            }
            if (!match) continue;
            this.seek(startPos + bytesDropped + (long)min + (long)tagLen);
            if (saveString) {
                out.setLength(min + tagLen);
                return out.toString();
            }
            return null;
        }
        if (tooLong) {
            throw new IOException("Maximum search length reached.");
        }
        return saveString ? out.toString() : null;
    }

    default public void writeLine(String string) throws IOException {
        this.writeBytes(string);
        this.writeBytes("\n");
    }

    default public int read() throws IOException {
        return this.offset() < this.length() ? this.readByte() & 0xFF : -1;
    }

    default public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] var1, int var2, int var3) throws IOException;

    default public long skip(long n) throws IOException {
        long skip = this.available(n);
        if (skip <= 0L) {
            return 0L;
        }
        this.seek(this.offset() + skip);
        return skip;
    }

    @Override
    default public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    default public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    default public int skipBytes(int n) throws IOException {
        int skip = (int)this.available(n);
        if (skip < 0) {
            return 0;
        }
        this.seek(this.offset() + (long)skip);
        return skip;
    }

    @Override
    default public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    default public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    default public short readShort() throws IOException {
        int ch1;
        int ch0;
        if (this.isBigEndian()) {
            ch0 = this.read();
            ch1 = this.read();
        } else {
            ch1 = this.read();
            ch0 = this.read();
        }
        if ((ch0 | ch1) < 0) {
            throw new EOFException();
        }
        return (short)((ch0 << 8) + (ch1 << 0));
    }

    @Override
    default public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    default public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    default public int readInt() throws IOException {
        int ch3;
        int ch2;
        int ch1;
        int ch0;
        if (this.isBigEndian()) {
            ch0 = this.read();
            ch1 = this.read();
            ch2 = this.read();
            ch3 = this.read();
        } else {
            ch3 = this.read();
            ch2 = this.read();
            ch1 = this.read();
            ch0 = this.read();
        }
        if ((ch0 | ch1 | ch2 | ch3) < 0) {
            throw new EOFException();
        }
        return (ch0 << 24) + (ch1 << 16) + (ch2 << 8) + (ch3 << 0);
    }

    @Override
    default public long readLong() throws IOException {
        int ch7;
        int ch6;
        int ch5;
        int ch4;
        int ch3;
        int ch2;
        int ch1;
        int ch0;
        if (this.isBigEndian()) {
            ch0 = this.read();
            ch1 = this.read();
            ch2 = this.read();
            ch3 = this.read();
            ch4 = this.read();
            ch5 = this.read();
            ch6 = this.read();
            ch7 = this.read();
        } else {
            ch7 = this.read();
            ch6 = this.read();
            ch5 = this.read();
            ch4 = this.read();
            ch3 = this.read();
            ch2 = this.read();
            ch1 = this.read();
            ch0 = this.read();
        }
        if ((ch0 | ch1 | ch2 | ch3 | ch4 | ch5 | ch6 | ch7) < 0) {
            throw new EOFException();
        }
        return ((long)ch0 << 56) + ((long)(ch1 & 0xFF) << 48) + ((long)(ch2 & 0xFF) << 40) + ((long)(ch3 & 0xFF) << 32) + ((long)(ch4 & 0xFF) << 24) + (long)((ch5 & 0xFF) << 16) + (long)((ch6 & 0xFF) << 8) + (long)((ch7 & 0xFF) << 0);
    }

    @Override
    default public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    default public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    default public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.offset();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    default public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    default public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    default public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    default public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    default public void writeShort(int v) throws IOException {
        if (this.isBigEndian()) {
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        } else {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
        }
    }

    @Override
    default public void writeChar(int v) throws IOException {
        if (this.isBigEndian()) {
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        } else {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
        }
    }

    @Override
    default public void writeInt(int v) throws IOException {
        if (this.isBigEndian()) {
            this.write(v >>> 24 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        } else {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 24 & 0xFF);
        }
    }

    @Override
    default public void writeLong(long v) throws IOException {
        if (this.isBigEndian()) {
            this.write((byte)(v >>> 56));
            this.write((byte)(v >>> 48));
            this.write((byte)(v >>> 40));
            this.write((byte)(v >>> 32));
            this.write((byte)(v >>> 24));
            this.write((byte)(v >>> 16));
            this.write((byte)(v >>> 8));
            this.write((byte)(v >>> 0));
        } else {
            this.write((byte)(v >>> 0));
            this.write((byte)(v >>> 8));
            this.write((byte)(v >>> 16));
            this.write((byte)(v >>> 24));
            this.write((byte)(v >>> 32));
            this.write((byte)(v >>> 40));
            this.write((byte)(v >>> 48));
            this.write((byte)(v >>> 56));
        }
    }

    @Override
    default public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    default public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    default public void writeBytes(String s) throws IOException {
        this.write(s.getBytes("UTF-8"));
    }

    @Override
    default public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    @Override
    default public void writeUTF(String str) throws IOException {
        DataHandles.writeUTF(str, this);
    }

    public static enum ByteOrder {
        LITTLE_ENDIAN,
        BIG_ENDIAN;

    }
}

