/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import java.lang.reflect.InvocationTargetException;
import org.scijava.Context;
import org.scijava.Gateway;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PreprocessorPlugin.class, priority=20000.0)
public class GatewayPreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter
    private LogService log;

    @Override
    public void process(Module module) {
        for (ModuleItem<?> input : module.getInfo().inputs()) {
            Class<?> type;
            if (!input.isAutoFill() || !Gateway.class.isAssignableFrom(type = input.getType())) continue;
            ModuleItem<?> gatewayInput = input;
            this.setGatewayValue(this.getContext(), module, gatewayInput);
        }
    }

    private <G extends Gateway> void setGatewayValue(Context context, Module module, ModuleItem<G> input) {
        Class<G> type = input.getType();
        Gateway gateway = null;
        Exception exception = null;
        try {
            gateway = (Gateway)type.getConstructor(Context.class).newInstance(context);
        }
        catch (IllegalArgumentException exc) {
            exception = exc;
        }
        catch (SecurityException exc) {
            exception = exc;
        }
        catch (InstantiationException exc) {
            exception = exc;
        }
        catch (IllegalAccessException exc) {
            exception = exc;
        }
        catch (InvocationTargetException exc) {
            exception = exc;
        }
        catch (NoSuchMethodException exc) {
            exception = exc;
        }
        if (exception != null) {
            this.log.warn("Could not instantiate gateway of type: " + type, exception);
            return;
        }
        input.setValue(module, gateway);
        module.resolveInput(input.getName());
    }
}

