/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.scijava.menu.ShadowMenu;
import org.scijava.module.ModuleInfo;

public class ShadowMenuIterator
implements Iterator<ModuleInfo> {
    private final ShadowMenu node;
    private final List<ShadowMenuIterator> childIterators;
    private int index;

    public ShadowMenuIterator(ShadowMenu node) {
        this.node = node;
        List<ShadowMenu> children = node.getChildren();
        this.childIterators = new ArrayList<ShadowMenuIterator>();
        for (ShadowMenu child : children) {
            this.childIterators.add(new ShadowMenuIterator(child));
        }
        this.index = node.getModuleInfo() == null ? 0 : -1;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.childIterators.size();
    }

    @Override
    public ModuleInfo next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.index < 0) {
            ++this.index;
            return this.node.getModuleInfo();
        }
        ShadowMenuIterator iter = this.childIterators.get(this.index);
        ModuleInfo next = iter.next();
        if (!iter.hasNext()) {
            ++this.index;
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

