/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import org.scijava.log.LogService;
import org.scijava.script.AdaptedScriptLanguage;
import org.scijava.script.ScriptLanguage;
import org.scijava.util.FileUtils;
import org.scijava.util.Types;

public class ScriptLanguageIndex
extends ArrayList<ScriptLanguage> {
    private static final long serialVersionUID = 1L;
    private final Map<String, ScriptLanguage> byExtension = new HashMap<String, ScriptLanguage>();
    private final Map<String, ScriptLanguage> byName = new HashMap<String, ScriptLanguage>();
    private final LogService log;

    @Deprecated
    public ScriptLanguageIndex() {
        this((LogService)null);
    }

    public ScriptLanguageIndex(LogService log) {
        this.log = log;
    }

    public boolean add(ScriptEngineFactory factory, boolean gently) {
        boolean result = false;
        ScriptLanguage language = this.wrap(factory);
        result |= this.put("name", this.byName, language.getLanguageName(), language, gently);
        for (String name : language.getNames()) {
            result |= this.put("name", this.byName, name, language, gently);
        }
        for (String extension : language.getExtensions()) {
            if ("".equals(extension)) continue;
            result |= this.put("extension", this.byExtension, extension, language, gently);
        }
        return result |= super.add(language);
    }

    public ScriptLanguage getByExtension(String extension) {
        return this.byExtension.get(extension);
    }

    public ScriptLanguage getByName(String name) {
        return this.byName.get(name);
    }

    public String[] getFileExtensions(ScriptLanguage language) {
        List<String> extensions = language.getExtensions();
        return extensions.toArray(new String[extensions.size()]);
    }

    public boolean canHandleFile(File file) {
        String extension = FileUtils.getExtension(file);
        if ("".equals(extension)) {
            return false;
        }
        return this.byExtension.containsKey(extension);
    }

    public boolean canHandleFile(String fileName) {
        String extension = FileUtils.getExtension(fileName);
        if ("".equals(extension)) {
            return false;
        }
        return this.byExtension.containsKey(extension);
    }

    @Override
    public boolean add(ScriptLanguage language) {
        return this.add(language, false);
    }

    private boolean put(String type, Map<String, ScriptLanguage> map, String key, ScriptLanguage value, boolean gently) {
        ScriptLanguage existing = map.get(key);
        if (existing == value) {
            if (this.log != null && this.log.isDebug()) {
                this.log.debug(this.overwriteMessage(false, type, key, value, existing));
            }
            return false;
        }
        if (existing != null) {
            if (gently) {
                if (this.log != null && this.log.isWarn()) {
                    this.log.warn(this.overwriteMessage(false, type, key, value, existing));
                }
                return false;
            }
            if (this.log != null && this.log.isDebug()) {
                this.log.debug(this.overwriteMessage(true, type, key, value, existing));
            }
        }
        map.put(key, value);
        return true;
    }

    private ScriptLanguage wrap(ScriptEngineFactory factory) {
        if (factory instanceof ScriptLanguage) {
            return (ScriptLanguage)factory;
        }
        return new AdaptedScriptLanguage(factory);
    }

    private String overwriteMessage(boolean overwrite, String type, String key, ScriptLanguage proposed, ScriptLanguage existing) {
        return (overwrite ? "Overwriting " : "Not overwriting ") + type + " '" + key + "':\n\tproposed = " + this.details(proposed) + "\n\texisting = " + this.details(existing);
    }

    private String details(ScriptLanguage language) {
        Class<?> c = language.getClass();
        return c.getName() + " [" + Types.location(c);
    }
}

