/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class LogSource {
    public static final String SEPARATOR = ":";
    private final LogSource parent;
    private final List<String> path;
    private final ConcurrentMap<String, LogSource> children = new ConcurrentSkipListMap<String, LogSource>();
    private String formatted = null;
    private Integer logLevel;

    private LogSource(LogSource parent, String name) {
        this.parent = parent;
        List<String> parentPath = parent.path();
        ArrayList<String> list = new ArrayList<String>(parentPath.size() + 1);
        list.addAll(parentPath);
        list.add(name);
        this.path = Collections.unmodifiableList(list);
    }

    private LogSource() {
        this.parent = null;
        this.path = Collections.emptyList();
    }

    public static LogSource newRoot() {
        return new LogSource();
    }

    public LogSource subSource(String subPath) {
        LogSource result = this;
        for (String name : subPath.split(SEPARATOR)) {
            result = result.child(name);
        }
        return result;
    }

    public List<String> path() {
        return this.path;
    }

    public String name() {
        if (this.path.isEmpty()) {
            return "";
        }
        return this.path.get(this.path.size() - 1);
    }

    public String toString() {
        if (this.formatted != null) {
            return this.formatted;
        }
        StringJoiner joiner = new StringJoiner(SEPARATOR);
        this.path.forEach(s -> joiner.add((CharSequence)s));
        this.formatted = joiner.toString();
        return this.formatted;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public LogSource parent() {
        return this.parent;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public int logLevel() {
        if (!this.hasLogLevel()) {
            throw new IllegalStateException();
        }
        return this.logLevel;
    }

    private LogSource child(String name) {
        if (name.isEmpty()) {
            return this;
        }
        LogSource child = (LogSource)this.children.get(name);
        if (child != null) {
            return child;
        }
        child = new LogSource(this, name);
        this.children.putIfAbsent(name, child);
        return (LogSource)this.children.get(name);
    }
}

