/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import java.net.URISyntaxException;
import org.scijava.event.EventService;
import org.scijava.io.IOPlugin;
import org.scijava.io.IOService;
import org.scijava.io.event.DataOpenedEvent;
import org.scijava.io.event.DataSavedEvent;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultIOService
extends AbstractHandlerService<Location, IOPlugin<?>>
implements IOService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;
    @Parameter
    private LocationService locationService;

    @Override
    public Object open(String source) throws IOException {
        try {
            return this.open(this.locationService.resolve(source));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void save(Object data, String destination) throws IOException {
        try {
            this.save(data, this.locationService.resolve(destination));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object open(Location source) throws IOException {
        IOPlugin<?> opener = this.getOpener(source);
        if (opener == null) {
            this.log.error("No opener IOPlugin found for " + source + ".");
            return null;
        }
        Object data = opener.open(source);
        if (data == null) {
            this.log.warn("Opener IOPlugin " + opener + " returned no data. Canceled?");
            return null;
        }
        this.eventService.publish(new DataOpenedEvent(source, data));
        return data;
    }

    @Override
    public void save(Object data, Location destination) throws IOException {
        IOPlugin<Object> saver = this.getSaver(data, destination);
        if (saver != null) {
            saver.save(data, destination);
            this.eventService.publish(new DataSavedEvent(destination, data));
        } else {
            this.log.error("No Saver IOPlugin found for " + data.toString() + ".");
        }
    }
}

