/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Types;

@Plugin(type=Converter.class, priority=1000000.0)
public class CastingConverter
extends AbstractConverter<Object, Object> {
    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        return Types.isInstance(src, dest);
    }

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        return dest != null && Types.isAssignable(src, dest);
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        Class<?> c = Types.raw(dest);
        return (T)Types.cast(src, c);
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<Object> getInputType() {
        return Object.class;
    }
}

