/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.HandlerPlugin;

public interface IOPlugin<D>
extends HandlerPlugin<Location> {
    public Class<D> getDataType();

    default public boolean supportsOpen(String source) {
        return this.supportsOpen(new FileLocation(source));
    }

    default public boolean supportsOpen(Location source) {
        return false;
    }

    default public boolean supportsSave(String destination) {
        return this.supportsSave(new FileLocation(destination));
    }

    default public boolean supportsSave(Location destination) {
        return false;
    }

    default public boolean supportsSave(Object data, String destination) {
        return this.supportsSave(destination) && this.getDataType().isInstance(data);
    }

    default public boolean supportsSave(Object data, Location destination) {
        return this.supportsSave(destination) && this.getDataType().isInstance(data);
    }

    default public D open(String source) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public D open(Location source) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void save(D data, String destination) throws IOException {
        this.save(data, new FileLocation(destination));
    }

    default public void save(D data, Location destination) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean supports(String descriptor) {
        return this.supportsOpen(descriptor) || this.supportsSave(descriptor);
    }

    @Override
    default public Class<Location> getType() {
        return Location.class;
    }
}

