/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.util.Arrays;
import org.scijava.io.handle.AbstractDataHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.DummyLocation;
import org.scijava.plugin.Plugin;

@Plugin(type=DataHandle.class)
public class DummyHandle
extends AbstractDataHandle<DummyLocation> {
    private long offset;
    private long length;

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public void seek(long pos) {
        if (pos > this.length()) {
            this.setLength(pos);
        }
        this.offset = pos;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public byte readByte() throws IOException {
        long r = this.available(1L);
        if (r <= 0L) {
            return -1;
        }
        ++this.offset;
        return 0;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = (int)this.available(len);
        this.offset += (long)r;
        Arrays.fill(b, off, off + r, (byte)0);
        return r;
    }

    @Override
    public void write(int v) throws IOException {
        this.ensureWritable(1L);
        ++this.offset;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureWritable(len);
        this.offset += (long)len;
    }

    @Override
    public void close() {
    }

    @Override
    public Class<DummyLocation> getType() {
        return DummyLocation.class;
    }
}

