/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.DigestUtils;

public class DigestUtilsTest {
    private static final byte[] COFFEE_SHA1 = new byte[]{-71, 2, 27, -126, -23, -70, -89, 35, -65, -15, -108, 66, 72, 113, 29, -32, -12, -42, -49, 6};
    private static final byte[] COFFEE_MD5 = new byte[]{-39, -98, 9, -40, -39, 44, 31, -62, 23, 9, 38, 101, 85, -57, 121, -110};
    private static final byte[] HELLO_WORLD_SHA1 = new byte[]{123, 80, 44, 58, 31, 72, -56, 96, -102, -30, 18, -51, -5, 99, -99, -18, 57, 103, 63, 94};
    private static final String HELLO_WORLD_SHA1_HEX = "7b502c3a1f48c8609ae212cdfb639dee39673f5e";
    private static final String COFFEE_SHA1_HEX = "b9021b82e9baa723bff1944248711de0f4d6cf06";
    private static final String HELLO_WORLD_SHA1_BASE64 = "e1AsOh9IyGCa4hLN+2Od7jlnP14=";
    private static final String COFFEE_SHA1_BASE64 = "uQIbgum6pyO/8ZRCSHEd4PTWzwY=";

    @Test
    public void testBytesString() {
        String s = "Hello world";
        byte[] bytes = DigestUtils.bytes((String)"Hello world");
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100};
        Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
    }

    @Test
    public void testBytesInt() {
        byte[] bytes = DigestUtils.bytes((int)12648430);
        byte[] expected = new byte[]{0, -64, -1, -18};
        Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
    }

    @Test
    public void testHex() {
        Assert.assertEquals((Object)"00c0ffee", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)12648430)));
        Assert.assertEquals((Object)"deadbeef", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)-559038737)));
        Assert.assertEquals((Object)"00000000", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)0)));
        Assert.assertEquals((Object)"ffffffff", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)-1)));
    }

    @Test
    public void testBase64() {
        Assert.assertEquals((Object)"AMD/7g==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)12648430)));
        Assert.assertEquals((Object)"3q2+7w==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)-559038737)));
        Assert.assertEquals((Object)"AAAAAA==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)0)));
        Assert.assertEquals((Object)"/////w==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)-1)));
    }

    @Test
    public void testHashString() {
        byte[] hash = DigestUtils.hash((String)"Hello world");
        byte[] expected = new byte[]{-50, 89, -118, -92};
        Assert.assertArrayEquals((byte[])expected, (byte[])hash);
    }

    @Test
    public void testHashBytes() {
        byte[] bytes = DigestUtils.bytes((String)"Hello world");
        byte[] hash = DigestUtils.hash((byte[])bytes);
        byte[] expected = new byte[]{-50, 89, -118, -92};
        Assert.assertArrayEquals((byte[])expected, (byte[])hash);
    }

    @Test
    public void testSHA1() {
        byte[] bytes = DigestUtils.bytes((int)12648430);
        byte[] sha1 = DigestUtils.sha1((byte[])bytes);
        Assert.assertArrayEquals((byte[])COFFEE_SHA1, (byte[])sha1);
    }

    @Test
    public void testMD5() {
        byte[] bytes = DigestUtils.bytes((int)12648430);
        byte[] md5 = DigestUtils.md5((byte[])bytes);
        Assert.assertArrayEquals((byte[])COFFEE_MD5, (byte[])md5);
    }

    @Test
    public void testDigest() {
        byte[] bytes = DigestUtils.bytes((int)12648430);
        byte[] sha1 = DigestUtils.digest((String)"SHA-1", (byte[])bytes);
        byte[] expectedSHA1 = DigestUtils.sha1((byte[])bytes);
        Assert.assertArrayEquals((byte[])expectedSHA1, (byte[])sha1);
        byte[] md5 = DigestUtils.digest((String)"MD5", (byte[])bytes);
        byte[] expectedMD5 = DigestUtils.md5((byte[])bytes);
        Assert.assertArrayEquals((byte[])expectedMD5, (byte[])md5);
    }

    @Test
    public void testBestString() {
        byte[] best = DigestUtils.best((String)"Hello world");
        Assert.assertArrayEquals((byte[])HELLO_WORLD_SHA1, (byte[])best);
    }

    @Test
    public void testBestBytes() {
        byte[] bytes = DigestUtils.bytes((int)12648430);
        byte[] best = DigestUtils.best((byte[])bytes);
        Assert.assertArrayEquals((byte[])COFFEE_SHA1, (byte[])best);
    }

    @Test
    public void testBestHexString() {
        Assert.assertEquals((Object)HELLO_WORLD_SHA1_HEX, (Object)DigestUtils.bestHex((String)"Hello world"));
    }

    @Test
    public void testBestHexBytes() {
        byte[] bytes = DigestUtils.bytes((int)12648430);
        Assert.assertEquals((Object)COFFEE_SHA1_HEX, (Object)DigestUtils.bestHex((byte[])bytes));
    }

    @Test
    public void testBestBase64String() {
        Assert.assertEquals((Object)HELLO_WORLD_SHA1_BASE64, (Object)DigestUtils.bestBase64((String)"Hello world"));
    }

    @Test
    public void testBestBase64Bytes() {
        byte[] bytes = DigestUtils.bytes((int)12648430);
        Assert.assertEquals((Object)COFFEE_SHA1_BASE64, (Object)DigestUtils.bestBase64((byte[])bytes));
    }
}

