/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.input;

import java.util.HashMap;
import java.util.Map;

public enum KeyCode {
    ENTER(10),
    BACK_SPACE(8),
    TAB(9),
    CANCEL(3),
    CLEAR(12),
    SHIFT(16),
    CONTROL(17),
    ALT(18),
    PAUSE(19),
    CAPS_LOCK(20),
    ESCAPE(27),
    SPACE(32),
    PAGE_UP(33),
    PAGE_DOWN(34),
    END(35),
    HOME(36),
    LEFT(37),
    UP(38),
    RIGHT(39),
    DOWN(40),
    COMMA(44),
    MINUS(45),
    PERIOD(46),
    SLASH(47),
    NUM0(48),
    NUM1(49),
    NUM2(50),
    NUM3(51),
    NUM4(52),
    NUM5(53),
    NUM6(54),
    NUM7(55),
    NUM8(56),
    NUM9(57),
    SEMICOLON(59),
    EQUALS(61),
    A(65),
    B(66),
    C(67),
    D(68),
    E(69),
    F(70),
    G(71),
    H(72),
    I(73),
    J(74),
    K(75),
    L(76),
    M(77),
    N(78),
    O(79),
    P(80),
    Q(81),
    R(82),
    S(83),
    T(84),
    U(85),
    V(86),
    W(87),
    X(88),
    Y(89),
    Z(90),
    OPEN_BRACKET(91),
    BACK_SLASH(92),
    CLOSE_BRACKET(93),
    NUMPAD_0(96),
    NUMPAD_1(97),
    NUMPAD_2(98),
    NUMPAD_3(99),
    NUMPAD_4(100),
    NUMPAD_5(101),
    NUMPAD_6(102),
    NUMPAD_7(103),
    NUMPAD_8(104),
    NUMPAD_9(105),
    NUMPAD_ASTERISK(106),
    NUMPAD_PLUS(107),
    NUMPAD_SEPARATOR(108),
    NUMPAD_MINUS(109),
    NUMPAD_PERIOD(110),
    NUMPAD_SLASH(111),
    DELETE(127),
    NUM_LOCK(144),
    SCROLL_LOCK(145),
    F1(112),
    F2(113),
    F3(114),
    F4(115),
    F5(116),
    F6(117),
    F7(118),
    F8(119),
    F9(120),
    F10(121),
    F11(122),
    F12(123),
    F13(61440),
    F14(61441),
    F15(61442),
    F16(61443),
    F17(61444),
    F18(61445),
    F19(61446),
    F20(61447),
    F21(61448),
    F22(61449),
    F23(61450),
    F24(61451),
    PRINTSCREEN(154),
    INSERT(155),
    HELP(156),
    META(157),
    BACK_QUOTE(192),
    QUOTE(222),
    KP_UP(224),
    KP_DOWN(225),
    KP_LEFT(226),
    KP_RIGHT(227),
    DEAD_GRAVE(128),
    DEAD_ACUTE(129),
    DEAD_CIRCUMFLEX(130),
    DEAD_TILDE(131),
    DEAD_MACRON(132),
    DEAD_BREVE(133),
    DEAD_ABOVEDOT(134),
    DEAD_DIAERESIS(135),
    DEAD_ABOVERING(136),
    DEAD_DOUBLEACUTE(137),
    DEAD_CARON(138),
    DEAD_CEDILLA(139),
    DEAD_OGONEK(140),
    DEAD_IOTA(141),
    DEAD_VOICED_SOUND(142),
    DEAD_SEMIVOICED_SOUND(143),
    AMPERSAND(150),
    ASTERISK(151),
    QUOTEDBL(152),
    LESS(153),
    GREATER(160),
    BRACELEFT(161),
    BRACERIGHT(162),
    AT(512),
    COLON(513),
    CIRCUMFLEX(514),
    DOLLAR(515),
    EURO_SIGN(516),
    EXCLAMATION_MARK(517),
    INVERTED_EXCLAMATION_MARK(518),
    LEFT_PARENTHESIS(519),
    NUMBER_SIGN(520),
    PLUS(521),
    RIGHT_PARENTHESIS(522),
    UNDERSCORE(523),
    WINDOWS(524),
    CONTEXT_MENU(525),
    FINAL(24),
    CONVERT(28),
    NONCONVERT(29),
    ACCEPT(30),
    MODECHANGE(31),
    KANA(21),
    KANJI(25),
    ALPHANUMERIC(240),
    KATAKANA(241),
    HIRAGANA(242),
    FULL_WIDTH(243),
    HALF_WIDTH(244),
    ROMAN_CHARACTERS(245),
    ALL_CANDIDATES(256),
    PREVIOUS_CANDIDATE(257),
    CODE_INPUT(258),
    JAPANESE_KATAKANA(259),
    JAPANESE_HIRAGANA(260),
    JAPANESE_ROMAN(261),
    KANA_LOCK(262),
    INPUT_METHOD_ON_OFF(263),
    CUT(65489),
    COPY(65485),
    PASTE(65487),
    UNDO(65483),
    AGAIN(65481),
    FIND(65488),
    PROPS(65482),
    STOP(65480),
    COMPOSE(65312),
    ALT_GRAPH(65406),
    BEGIN(65368),
    UNDEFINED(0);

    private static final Map<Integer, KeyCode> CODES;
    private static final Map<String, KeyCode> NAMES;
    private int code;

    private KeyCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static KeyCode get(int code) {
        KeyCode keyCode = CODES.get(code);
        if (keyCode == null) {
            return UNDEFINED;
        }
        return keyCode;
    }

    public static KeyCode get(char c) {
        switch (c) {
            case '\n': 
            case '\r': {
                return ENTER;
            }
            case '\b': {
                return BACK_SPACE;
            }
            case '\t': {
                return TAB;
            }
            case '\u001b': {
                return ESCAPE;
            }
            case ' ': {
                return SPACE;
            }
            case ',': {
                return COMMA;
            }
            case '-': {
                return MINUS;
            }
            case '.': {
                return PERIOD;
            }
            case '/': {
                return SLASH;
            }
            case '0': {
                return NUM0;
            }
            case '1': {
                return NUM1;
            }
            case '2': {
                return NUM2;
            }
            case '3': {
                return NUM3;
            }
            case '4': {
                return NUM4;
            }
            case '5': {
                return NUM5;
            }
            case '6': {
                return NUM6;
            }
            case '7': {
                return NUM7;
            }
            case '8': {
                return NUM8;
            }
            case '9': {
                return NUM9;
            }
            case ';': {
                return SEMICOLON;
            }
            case '=': {
                return EQUALS;
            }
            case 'A': 
            case 'a': {
                return A;
            }
            case 'B': 
            case 'b': {
                return B;
            }
            case 'C': 
            case 'c': {
                return C;
            }
            case 'D': 
            case 'd': {
                return D;
            }
            case 'E': 
            case 'e': {
                return E;
            }
            case 'F': 
            case 'f': {
                return F;
            }
            case 'G': 
            case 'g': {
                return G;
            }
            case 'H': 
            case 'h': {
                return H;
            }
            case 'I': 
            case 'i': {
                return I;
            }
            case 'J': 
            case 'j': {
                return J;
            }
            case 'K': 
            case 'k': {
                return K;
            }
            case 'L': 
            case 'l': {
                return L;
            }
            case 'M': 
            case 'm': {
                return M;
            }
            case 'N': 
            case 'n': {
                return N;
            }
            case 'O': 
            case 'o': {
                return O;
            }
            case 'P': 
            case 'p': {
                return P;
            }
            case 'Q': 
            case 'q': {
                return Q;
            }
            case 'R': 
            case 'r': {
                return R;
            }
            case 'S': 
            case 's': {
                return S;
            }
            case 'T': 
            case 't': {
                return T;
            }
            case 'U': 
            case 'u': {
                return U;
            }
            case 'V': 
            case 'v': {
                return V;
            }
            case 'W': 
            case 'w': {
                return W;
            }
            case 'X': 
            case 'x': {
                return X;
            }
            case 'Y': 
            case 'y': {
                return Y;
            }
            case 'Z': 
            case 'z': {
                return Z;
            }
            case '[': {
                return OPEN_BRACKET;
            }
            case '\\': {
                return BACK_SLASH;
            }
            case ']': {
                return CLOSE_BRACKET;
            }
            case '`': {
                return BACK_QUOTE;
            }
            case '\'': {
                return QUOTE;
            }
            case '&': {
                return AMPERSAND;
            }
            case '*': {
                return ASTERISK;
            }
            case '\"': {
                return QUOTEDBL;
            }
            case '<': {
                return LESS;
            }
            case '>': {
                return GREATER;
            }
            case '{': {
                return BRACELEFT;
            }
            case '}': {
                return BRACERIGHT;
            }
            case '@': {
                return AT;
            }
            case ':': {
                return COLON;
            }
            case '^': {
                return CIRCUMFLEX;
            }
            case '$': {
                return DOLLAR;
            }
            case '\u20ac': {
                return EURO_SIGN;
            }
            case '!': {
                return EXCLAMATION_MARK;
            }
            case '\u00a1': {
                return INVERTED_EXCLAMATION_MARK;
            }
            case '(': {
                return LEFT_PARENTHESIS;
            }
            case '#': {
                return NUMBER_SIGN;
            }
            case '+': {
                return PLUS;
            }
            case ')': {
                return RIGHT_PARENTHESIS;
            }
            case '_': {
                return UNDERSCORE;
            }
        }
        return UNDEFINED;
    }

    public static KeyCode get(String name) {
        KeyCode keyCode = NAMES.get(name);
        if (keyCode != null) {
            return keyCode;
        }
        if (name.length() == 1) {
            return KeyCode.get(name.charAt(0));
        }
        return UNDEFINED;
    }

    static {
        CODES = new HashMap<Integer, KeyCode>();
        NAMES = new HashMap<String, KeyCode>();
        for (KeyCode keyCode : KeyCode.values()) {
            CODES.put(keyCode.getCode(), keyCode);
            NAMES.put(keyCode.name(), keyCode);
        }
    }
}

