/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.scijava.concurrent.TaskExecutor;
import org.scijava.concurrent.TaskExecutors;

public final class Parallelization {
    private static final ThreadLocal<TaskExecutor> executor = ThreadLocal.withInitial(TaskExecutors::multiThreaded);

    private Parallelization() {
    }

    public static TaskExecutor getTaskExecutor() {
        return executor.get();
    }

    public static ExecutorService getExecutorService() {
        return Parallelization.getTaskExecutor().getExecutorService();
    }

    public static void runSingleThreaded(Runnable action) {
        Parallelization.runWithExecutor(TaskExecutors.singleThreaded(), action);
    }

    public static <T> T runSingleThreaded(Callable<T> action) {
        return Parallelization.runWithExecutor(TaskExecutors.singleThreaded(), action);
    }

    public static void runMultiThreaded(Runnable action) {
        Parallelization.runWithExecutor(TaskExecutors.multiThreaded(), action);
    }

    public static <T> T runMultiThreaded(Callable<T> action) {
        return Parallelization.runWithExecutor(TaskExecutors.multiThreaded(), action);
    }

    public static void runWithNumThreads(int numThreads, Runnable action) {
        try (TaskExecutor taskExecutor = TaskExecutors.numThreads(numThreads);){
            Parallelization.runWithExecutor(taskExecutor, action);
        }
    }

    public static <R> R runWithNumThreads(int numThreads, Callable<R> action) {
        try (TaskExecutor taskExecutor = TaskExecutors.numThreads(numThreads);){
            R r = Parallelization.runWithExecutor(taskExecutor, action);
            return r;
        }
    }

    public static void runWithExecutor(ExecutorService executorService, Runnable action) {
        Parallelization.runWithExecutor(TaskExecutors.forExecutorService(executorService), action);
    }

    public static <R> R runWithExecutor(ExecutorService executorService, Callable<R> action) {
        return Parallelization.runWithExecutor(TaskExecutors.forExecutorService(executorService), action);
    }

    public static void runWithExecutor(TaskExecutor taskExecutor, Runnable action) {
        try (Frame frame = Parallelization.setExecutorRequiresReset(taskExecutor);){
            action.run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runWithExecutor(TaskExecutor taskExecutor, Callable<T> action) {
        try (Frame frame = Parallelization.setExecutorRequiresReset(taskExecutor);){
            T t = action.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Frame setExecutorRequiresReset(TaskExecutor taskExecutor) {
        TaskExecutor old = executor.get();
        executor.set(taskExecutor);
        return () -> executor.set(old);
    }

    static interface Frame
    extends AutoCloseable {
        @Override
        public void close();
    }
}

