/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.sjep.Position;
import org.scijava.sjep.SubSequence;

public final class Literals {
    private static final Pattern HEX = Pattern.compile("(([-+]?)0[Xx]([0-9a-fA-F]+)([Ll]?)).*");
    private static final Pattern BINARY = Pattern.compile("(([-+]?)0[Bb]([01]+)([Ll]?)).*");
    private static final Pattern OCTAL = Pattern.compile("(([-+]?)0([0-7]+)([Ll]?)).*");
    private static final Pattern DECIMAL = Pattern.compile("(([-+]?[0-9]+(\\.[0-9]*)?([Ee][0-9]+)?)([Dd]|[Ff]|[Ll])?).*");

    private Literals() {
    }

    public static Boolean parseBoolean(CharSequence s) {
        return Literals.parseBoolean(s, new Position());
    }

    public static String parseString(CharSequence s) {
        return Literals.parseString(s, new Position());
    }

    public static Number parseHex(CharSequence s) {
        return Literals.parseHex(s, new Position());
    }

    public static Number parseBinary(CharSequence s) {
        return Literals.parseBinary(s, new Position());
    }

    public static Number parseOctal(CharSequence s) {
        return Literals.parseOctal(s, new Position());
    }

    public static Number parseDecimal(CharSequence s) {
        return Literals.parseDecimal(s, new Position());
    }

    public static Number parseNumber(CharSequence s) {
        return Literals.parseNumber(s, new Position());
    }

    public static Object parseLiteral(CharSequence s) {
        return Literals.parseLiteral(s, new Position());
    }

    public static Boolean parseBoolean(CharSequence s, Position pos) {
        if (Literals.isWord(s, pos, "true")) {
            pos.inc(4);
            return Boolean.TRUE;
        }
        if (Literals.isWord(s, pos, "false")) {
            pos.inc(5);
            return Boolean.FALSE;
        }
        return null;
    }

    public static String parseString(CharSequence s, Position pos) {
        char quote = pos.ch(s);
        if (quote != '\"' && quote != '\'') {
            return null;
        }
        int index = pos.get() + 1;
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (index >= s.length()) {
                pos.die("Unclosed string literal");
            }
            char c = s.charAt(index);
            if (escaped) {
                escaped = false;
                if (Literals.isOctal(c)) {
                    String octal = "" + c;
                    char c1 = pos.ch(s, index + 1);
                    if (Literals.isOctal(c1)) {
                        char c2;
                        octal = octal + c1;
                        if (c >= '0' && c <= '3' && Literals.isOctal(c2 = pos.ch(s, index + 2))) {
                            octal = octal + c2;
                        }
                    }
                    sb.append((char)Integer.parseInt(octal, 8));
                    index += octal.length();
                    continue;
                }
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 'u': {
                        char u1 = Literals.hex(s, pos, index + 1);
                        char u2 = Literals.hex(s, pos, index + 2);
                        char u3 = Literals.hex(s, pos, index + 3);
                        char u4 = Literals.hex(s, pos, index + 4);
                        sb.append((char)Integer.parseInt("" + u1 + u2 + u3 + u4, 16));
                        index += 5;
                        break;
                    }
                    default: {
                        pos.die("Invalid escape sequence");
                        break;
                    }
                }
            } else if (c == '\\' && quote == '\"') {
                escaped = true;
            } else {
                if (c == quote) break;
                sb.append(c);
            }
            ++index;
        }
        pos.set(index + 1);
        return sb.toString();
    }

    public static Number parseHex(CharSequence s, Position pos) {
        return Literals.parseInteger(HEX, s, pos, 16);
    }

    public static Number parseBinary(CharSequence s, Position pos) {
        return Literals.parseInteger(BINARY, s, pos, 2);
    }

    public static Number parseOctal(CharSequence s, Position pos) {
        return Literals.parseInteger(OCTAL, s, pos, 8);
    }

    public static Number parseDecimal(CharSequence s, Position pos) {
        if (!Literals.isNumberSyntax(s, pos)) {
            return null;
        }
        Matcher m = Literals.matcher(DECIMAL, s, pos);
        if (!m.matches()) {
            return null;
        }
        String number = m.group(2);
        String force = m.group(5);
        boolean forceLong = "l".equalsIgnoreCase(force);
        boolean forceFloat = "f".equalsIgnoreCase(force);
        boolean forceDouble = "d".equalsIgnoreCase(force);
        Number result = null;
        if (!forceFloat && !forceDouble) {
            result = Literals.parseInteger(number, forceLong, 10);
        }
        if (result == null && !forceLong) {
            result = Literals.parseDecimal(number, forceFloat, forceDouble);
        }
        return Literals.verifyResult(result, m, pos);
    }

    public static Number parseNumber(CharSequence s, Position pos) {
        Number hex = Literals.parseHex(s, pos);
        if (hex != null) {
            return hex;
        }
        Number binary = Literals.parseBinary(s, pos);
        if (binary != null) {
            return binary;
        }
        Number octal = Literals.parseOctal(s, pos);
        if (octal != null) {
            return octal;
        }
        Number decimal = Literals.parseDecimal(s, pos);
        if (decimal != null) {
            return decimal;
        }
        return null;
    }

    public static Object parseLiteral(CharSequence s, Position pos) {
        Boolean bool = Literals.parseBoolean(s, pos);
        if (bool != null) {
            return bool;
        }
        String str = Literals.parseString(s, pos);
        if (str != null) {
            return str;
        }
        Number num = Literals.parseNumber(s, pos);
        if (num != null) {
            return num;
        }
        return null;
    }

    private static boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    private static char hex(CharSequence s, Position pos, int index) {
        char c = pos.ch(s, index);
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c >= 'a' && c <= 'f') {
            return c;
        }
        if (c >= 'A' && c <= 'F') {
            return c;
        }
        pos.die("Invalid unicode sequence");
        return '\u0000';
    }

    private static boolean isNumberSyntax(CharSequence s, Position pos) {
        int i = pos.get();
        boolean sign = s.charAt(i) == '-' || s.charAt(i) == '+';
        char digit = s.charAt(sign ? i + 1 : i);
        return digit >= '0' && digit <= '9';
    }

    private static Number parseInteger(Pattern p, CharSequence s, Position pos, int base) {
        if (!Literals.isNumberSyntax(s, pos)) {
            return null;
        }
        Matcher m = Literals.matcher(p, s, pos);
        if (!m.matches()) {
            return null;
        }
        String sign = m.group(2);
        if (sign == null) {
            sign = "";
        }
        String number = sign + m.group(3);
        boolean forceLong = !m.group(4).isEmpty();
        Number result = Literals.parseInteger(number, forceLong, base);
        return Literals.verifyResult(result, m, pos);
    }

    private static Number parseInteger(String number, boolean forceLong, int base) {
        if (!forceLong) {
            try {
                return Integer.parseInt(number, base);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        try {
            return Long.parseLong(number, base);
        }
        catch (NumberFormatException exc) {
            if (!forceLong) {
                try {
                    return new BigInteger(number, base);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static Number parseDecimal(String number, boolean forceFloat, boolean forceDouble) {
        if (forceFloat) {
            try {
                return Float.valueOf(Float.parseFloat(number));
            }
            catch (NumberFormatException exc) {
            }
        } else {
            try {
                return Double.parseDouble(number);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        if (!forceDouble && !forceFloat) {
            try {
                return new BigDecimal(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Matcher matcher(Pattern p, CharSequence s, Position pos) {
        return p.matcher(Literals.sub(s, pos));
    }

    private static CharSequence sub(CharSequence s, Position pos) {
        return pos.get() == 0 ? s : new SubSequence(s, pos.get());
    }

    private static Number verifyResult(Number result, Matcher m, Position pos) {
        if (result == null) {
            pos.die("Illegal numeric literal");
        }
        pos.inc(m.group(1).length());
        return result;
    }

    private static boolean isWord(CharSequence s, Position pos, String word) {
        if (s.length() - pos.get() < word.length()) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            if (pos.ch(s, i) == word.charAt(i)) continue;
            return false;
        }
        char next = pos.ch(s, word.length());
        if (next >= 'a' && next <= 'z') {
            return false;
        }
        if (next >= 'A' && next <= 'Z') {
            return false;
        }
        if (next >= '0' && next <= '9') {
            return false;
        }
        return next != '_';
    }
}

