/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.codehaus.plexus.util.FileUtils;
import org.scijava.maven.plugin.enforcer.AbstractResolveDependencies;
import org.scijava.maven.plugin.enforcer.Dependency;

public class BanDuplicateClasses
extends AbstractResolveDependencies {
    private String message;
    private String[] ignoreClasses;
    private boolean findAllDuplicates;
    private List<Dependency> dependencies;
    private List<String> scopes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleArtifacts(Set<Artifact> artifacts) throws EnforcerRuleException {
        ArrayList<AbstractResolveDependencies.IgnorableDependency> ignorableDependencies = new ArrayList<AbstractResolveDependencies.IgnorableDependency>();
        if (this.ignoreClasses != null) {
            AbstractResolveDependencies.IgnorableDependency ignorableDependency = new AbstractResolveDependencies.IgnorableDependency(this);
            ignorableDependency.applyIgnoreClasses(this.ignoreClasses, false);
            ignorableDependencies.add(ignorableDependency);
        }
        if (this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                this.getLog().info((CharSequence)("Adding ignorable dependency: " + dependency));
                AbstractResolveDependencies.IgnorableDependency ignorableDependency = new AbstractResolveDependencies.IgnorableDependency(this);
                if (dependency.getGroupId() != null) {
                    ignorableDependency.groupId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getGroupId()));
                }
                if (dependency.getArtifactId() != null) {
                    ignorableDependency.artifactId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getArtifactId()));
                }
                if (dependency.getType() != null) {
                    ignorableDependency.type = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getType()));
                }
                if (dependency.getClassifier() != null) {
                    ignorableDependency.classifier = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getClassifier()));
                }
                ignorableDependency.applyIgnoreClasses(dependency.getIgnoreClasses(), true);
                ignorableDependencies.add(ignorableDependency);
            }
        }
        HashMap<String, Artifact> classNames = new HashMap<String, Artifact>();
        HashMap<String, Set<Artifact>> duplicates = new HashMap<String, Set<Artifact>>();
        for (Artifact o : artifacts) {
            if (this.scopes != null && !this.scopes.contains(o.getScope())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping " + o.toString() + " due to scope"));
                continue;
            }
            File file = o.getFile();
            this.getLog().debug((CharSequence)("Searching for duplicate classes in " + file));
            if (file == null || !file.exists()) {
                this.getLog().warn((CharSequence)("Could not find " + o + " at " + file));
                continue;
            }
            if (file.isDirectory()) {
                try {
                    List fileNames = FileUtils.getFileNames((File)file, null, null, (boolean)false);
                    for (String name : fileNames) {
                        this.getLog().debug((CharSequence)("  " + name));
                        this.checkAndAddName(o, name, classNames, duplicates, ignorableDependencies);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new EnforcerRuleException("Unable to process dependency " + o.toString() + " due to " + e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (!file.isFile() || !"jar".equals(o.getType())) continue;
            try {
                JarFile jar = new JarFile(file);
                try {
                    for (JarEntry entry : Collections.list(jar.entries())) {
                        this.checkAndAddName(o, entry.getName(), classNames, duplicates, ignorableDependencies);
                    }
                }
                finally {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (IOException e) {
                throw new EnforcerRuleException("Unable to process dependency " + o.toString() + " due to " + e.getLocalizedMessage(), (Exception)e);
            }
        }
        if (!duplicates.isEmpty()) {
            HashMap inverted = new HashMap();
            for (Map.Entry entry : duplicates.entrySet()) {
                ArrayList s = (ArrayList)inverted.get(entry.getValue());
                if (s == null) {
                    s = new ArrayList();
                }
                s.add(entry.getKey());
                inverted.put(entry.getValue(), s);
            }
            StringBuilder buf = new StringBuilder(this.message == null ? "Duplicate classes found:" : this.message);
            buf.append('\n');
            for (Map.Entry entry : inverted.entrySet()) {
                buf.append("\n  Found in:");
                for (Artifact a : (Set)entry.getKey()) {
                    buf.append("\n    ");
                    buf.append(a);
                }
                buf.append("\n  Duplicate classes:");
                for (String className : (List)entry.getValue()) {
                    buf.append("\n    ");
                    buf.append(className);
                }
                buf.append('\n');
            }
            throw new EnforcerRuleException(buf.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkAndAddName(Artifact artifact, String name, Map<String, Artifact> classNames, Map<String, Set<Artifact>> duplicates, Collection<AbstractResolveDependencies.IgnorableDependency> ignores) throws EnforcerRuleException {
        if (!name.endsWith(".class")) {
            return;
        }
        for (AbstractResolveDependencies.IgnorableDependency c : ignores) {
            if (!c.matchesArtifact(artifact) || !c.matches(name)) continue;
            if (!classNames.containsKey(name)) return;
            this.getLog().debug((CharSequence)("Ignoring excluded class " + name));
            return;
        }
        if (!classNames.containsKey(name)) {
            classNames.put(name, artifact);
            return;
        }
        Artifact dup = classNames.put(name, artifact);
        if (!this.findAllDuplicates || !duplicates.containsKey(name)) {
            for (AbstractResolveDependencies.IgnorableDependency c : ignores) {
                if (!c.matchesArtifact(artifact) || !c.matches(name)) continue;
                this.getLog().debug((CharSequence)("Ignoring duplicate class " + name));
                return;
            }
        }
        if (this.findAllDuplicates) {
            Set<Artifact> dups = duplicates.get(name);
            if (dups == null) {
                dups = new LinkedHashSet<Artifact>();
                dups.add(dup);
            }
            dups.add(artifact);
            duplicates.put(name, dups);
            return;
        }
        StringBuilder buf = new StringBuilder(this.message == null ? "Duplicate class found:" : this.message);
        buf.append('\n');
        buf.append("\n  Found in:");
        buf.append("\n    ");
        buf.append(dup);
        buf.append("\n    ");
        buf.append(artifact);
        buf.append("\n  Duplicate classes:");
        buf.append("\n    ");
        buf.append(name);
        buf.append('\n');
        buf.append("There may be others but <findAllDuplicates> was set to false, so failing fast");
        throw new EnforcerRuleException(buf.toString());
    }
}

