/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.install;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.scijava.maven.plugin.install.AbstractCopyJarsMojo;

@Mojo(name="copy-jars", requiresProject=true, requiresOnline=true)
public class CopyJarsMojo
extends AbstractCopyJarsMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    private DependencyResolver dependencyResolver;
    private DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
    private File appDir;
    @Component
    private ProjectBuilder mavenProjectBuilder;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        this.handleBackwardCompatibility();
        if (this.appDirectory == null) {
            if (!this.hasIJ1Dependency(this.project)) return;
            this.getLog().info((CharSequence)"Property 'scijava.app.directory' unset; Skipping copy-jars");
            return;
        }
        String interpolated = this.interpolate(this.appDirectory, this.project, this.session);
        this.appDir = new File(interpolated);
        if (this.appSubdirectory == null) {
            this.getLog().info((CharSequence)"No property name for the scijava.app.subdirectory directory location was specified; Installing in default location");
        }
        if (!this.appDir.isDirectory()) {
            this.getLog().warn((CharSequence)("'" + this.appDirectory + "'" + (interpolated.equals(this.appDirectory) ? "" : " (" + this.appDirectory + ")") + " is not an SciJava application directory; Skipping copy-jars"));
            return;
        }
        this.coordinate.setGroupId(this.project.getGroupId());
        this.coordinate.setArtifactId(this.project.getArtifactId());
        this.coordinate.setVersion(this.project.getVersion());
        this.coordinate.setType(this.project.getPackaging());
        try {
            ScopeFilter scopeFilter = ScopeFilter.excluding((String[])new String[]{"system", "provided", "test"});
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            Iterable resolveDependencies = this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, (DependableCoordinate)this.coordinate, (TransformableFilter)scopeFilter);
            for (ArtifactResult result : resolveDependencies) {
                try {
                    if (this.project.getArtifact().equals(result.getArtifact())) {
                        this.installArtifact(result.getArtifact(), this.appDir, this.appSubdirectory, false, this.deleteOtherVersionsPolicy);
                        continue;
                    }
                    if (this.ignoreDependencies) continue;
                    ProjectBuildingResult build = this.mavenProjectBuilder.build(result.getArtifact(), this.session.getProjectBuildingRequest());
                    Properties properties = build.getProject().getProperties();
                    String subdir = (String)properties.get("scijava.app.subdirectory");
                    this.installArtifact(result.getArtifact(), this.appDir, subdir, false, this.deleteOtherVersionsPolicy);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Couldn't download artifact " + result.getArtifact() + ": " + e.getMessage(), (Exception)e);
                }
                catch (ProjectBuildingException e) {
                    throw new MojoExecutionException("Couldn't determine scijava.app.subdirectory for " + result.getArtifact(), (Exception)((Object)e));
                    return;
                }
            }
        }
        catch (DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't resolve dependencies for artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

