/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.reduce;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.OpInfoGenerator;
import org.scijava.ops.engine.matcher.reduce.InfoReducer;
import org.scijava.struct.Member;

public class ReducedOpInfoGenerator
implements OpInfoGenerator {
    public static final List<InfoReducer> infoReducers = ServiceLoader.load(InfoReducer.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());

    @Override
    public boolean canGenerateFrom(Object o) {
        if (!(o instanceof OpInfo)) {
            return false;
        }
        OpInfo info = (OpInfo)o;
        boolean allParamsRequired = info.inputs().parallelStream().allMatch(Member::isRequired);
        if (allParamsRequired) {
            return false;
        }
        return infoReducers.parallelStream().anyMatch(reducer -> reducer.canReduce(info));
    }

    @Override
    public List<OpInfo> generateInfosFrom(Object o) {
        if (!(o instanceof OpInfo)) {
            return Collections.emptyList();
        }
        return this.reduce((OpInfo)o);
    }

    private List<OpInfo> reduce(OpInfo info) {
        Optional<InfoReducer> optionalReducer = infoReducers.parallelStream().filter(infoReducer -> infoReducer.canReduce(info)).findAny();
        if (optionalReducer.isEmpty()) {
            return Collections.emptyList();
        }
        int numReductions = (int)info.struct().members().parallelStream().filter(m -> !m.isRequired()).count();
        InfoReducer reducer = optionalReducer.get();
        LongFunction<OpInfo> func = l -> reducer.reduce(info, (int)l);
        return LongStream.range(1L, numReductions + 1).mapToObj(func).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

