/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.opencv;

import java.io.File;
import net.imagej.opencv.MatToImgConverter;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;

public class TestOpenCV {
    private static final String TEST_OP = "cv.GaussianBlur";
    private static final String TEST_OP_ALIAS = "filter.gauss";
    private static final String EXPECTED_HELP = "cv.GaussianBlur:\n\t- (image, @CONTAINER image, Size, number) -> None\n\t- (image, @CONTAINER image, Size, number, number, number) -> None";
    private static final String EXPECTED_HELP_VERBOSE = "cv.GaussianBlur:\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.GpuMat,org.bytedeco.opencv.opencv_core.GpuMat,org.bytedeco.opencv.opencv_core.Size,double)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.GpuMat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.GpuMat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.GpuMat,org.bytedeco.opencv.opencv_core.GpuMat,org.bytedeco.opencv.opencv_core.Size,double,double,int)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.GpuMat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.GpuMat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t\t> arg4 : java.lang.Double\n\t\t> arg5 : java.lang.Integer\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.Mat,org.bytedeco.opencv.opencv_core.Mat,org.bytedeco.opencv.opencv_core.Size,double)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.Mat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.Mat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.Mat,org.bytedeco.opencv.opencv_core.Mat,org.bytedeco.opencv.opencv_core.Size,double,double,int)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.Mat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.Mat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t\t> arg4 : java.lang.Double\n\t\t> arg5 : java.lang.Integer\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.UMat,org.bytedeco.opencv.opencv_core.UMat,org.bytedeco.opencv.opencv_core.Size,double)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.UMat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.UMat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.UMat,org.bytedeco.opencv.opencv_core.UMat,org.bytedeco.opencv.opencv_core.Size,double,double,int)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.UMat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.UMat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t\t> arg4 : java.lang.Double\n\t\t> arg5 : java.lang.Integer";
    private static final String EXPECTED_USAGE = "cv.GaussianBlur:\n\t- (image, @CONTAINER image, Size, number) -> None";
    private static final String EXPECTED_USAGE_VERBOSE = "cv.GaussianBlur:\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.GpuMat,org.bytedeco.opencv.opencv_core.GpuMat,org.bytedeco.opencv.opencv_core.Size,double)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.GpuMat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.GpuMat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.Mat,org.bytedeco.opencv.opencv_core.Mat,org.bytedeco.opencv.opencv_core.Size,double)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.Mat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.Mat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double\n\t- org.bytedeco.opencv.global.opencv_imgproc.GaussianBlur(org.bytedeco.opencv.opencv_core.UMat,org.bytedeco.opencv.opencv_core.UMat,org.bytedeco.opencv.opencv_core.Size,double)\n\t\t> arg0 : org.bytedeco.opencv.opencv_core.UMat\n\t\t> arg1 : @CONTAINER org.bytedeco.opencv.opencv_core.UMat\n\t\t> arg2 : org.bytedeco.opencv.opencv_core.Size\n\t\t> arg3 : java.lang.Double";

    @Test
    public void testDiscovery() {
        OpEnvironment ops = OpEnvironment.build();
        Assertions.assertEquals((Object)EXPECTED_HELP, (Object)ops.help(TEST_OP));
        Assertions.assertEquals((Object)EXPECTED_HELP_VERBOSE, (Object)ops.helpVerbose(TEST_OP));
    }

    @Test
    public void testUsage() {
        OpEnvironment ops = OpEnvironment.build();
        Mat src = this.openFish();
        Mat opsFish = new Mat(src.rows(), src.cols(), src.type());
        Mat opencvFish = new Mat(src.rows(), src.cols(), src.type());
        int stDev = 100;
        Size size = new Size(5, 5);
        OpBuilder.Arity3_IV_OV builder = ops.op(TEST_OP).input((Object)src, (Object)size, (Object)stDev).output((Object)opsFish);
        Assertions.assertEquals((Object)EXPECTED_USAGE, (Object)builder.help());
        Assertions.assertEquals((Object)EXPECTED_USAGE_VERBOSE, (Object)builder.helpVerbose());
        builder.compute();
        opencv_imgproc.GaussianBlur((Mat)src, (Mat)opencvFish, (Size)size, (double)stDev);
        this.verifyMats(opencvFish, opsFish);
        opsFish = new Mat(src.rows(), src.cols(), src.type());
        ops.op(TEST_OP_ALIAS).input((Object)src, (Object)size, (Object)stDev).output((Object)opsFish).compute();
        this.verifyMats(opencvFish, opsFish);
    }

    @Test
    public void testImgToMat() {
        OpEnvironment ops = OpEnvironment.build();
        int w = 130;
        int h = 130;
        ArrayImg src = ArrayImgs.unsignedBytes((byte[])this.randomBytes(w * h), (long[])new long[]{w, h});
        Img dest = src.copy();
        int stDev = 100;
        Size size = new Size(5, 5);
        ops.op(TEST_OP).input((Object)src, (Object)size, (Object)stDev).output((Object)dest).compute();
    }

    @Test
    public void testMatToImg() {
        OpEnvironment ops = OpEnvironment.build();
        Mat src = this.openFish();
        Mat out = new Mat(src.rows(), src.cols(), src.type());
        ops.op(TEST_OP_ALIAS).input((Object)src, (Object)100.0).output((Object)out).compute();
    }

    private void verifyMats(Mat expectedMat, Mat actualMat) {
        Assertions.assertEquals((int)expectedMat.rows(), (int)actualMat.rows());
        Assertions.assertEquals((int)expectedMat.cols(), (int)actualMat.cols());
        byte[] opencvBytes = MatToImgConverter.toByteArray((Mat)expectedMat);
        byte[] opsFishBytes = MatToImgConverter.toByteArray((Mat)actualMat);
        Assertions.assertArrayEquals((byte[])opencvBytes, (byte[])opsFishBytes);
    }

    private Mat openFish() {
        return opencv_imgcodecs.imread((String)new File(this.getClass().getResource("/HappyFish.jpg").getFile()).getAbsolutePath());
    }

    private byte[] randomBytes(int length) {
        byte[] data = new byte[length];
        data[0] = 123;
        for (int i = 1; i < data.length; ++i) {
            int d = data[i - 1];
            d ^= d >> 12;
            d ^= d << 25;
            d ^= d >> 27;
            data[i] = (byte)d;
        }
        return data;
    }
}

