/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.scijava.progress.Task;

public final class Progress {
    private static final List<Consumer<Task>> globalListeners = new CopyOnWriteArrayList<Consumer<Task>>();
    private static final Map<Object, List<Consumer<Task>>> progressibleListeners = new WeakHashMap<Object, List<Consumer<Task>>>();
    private static final NOPTask IGNORED = new NOPTask();
    private static final ThreadLocal<ArrayDeque<Task>> progressibleStack = new InheritableThreadLocal<ArrayDeque<Task>>(){
        private final Collection<Task> initialContents = Collections.singleton(IGNORED);

        @Override
        protected ArrayDeque<Task> childValue(ArrayDeque<Task> parentValue) {
            return parentValue.clone();
        }

        @Override
        protected ArrayDeque<Task> initialValue() {
            return new ArrayDeque<Task>(this.initialContents);
        }
    };

    private Progress() {
    }

    public static void addGlobalListener(Consumer<Task> l) {
        if (!globalListeners.contains(l)) {
            globalListeners.add(l);
        }
    }

    public static void addListener(Object progressible, Consumer<Task> l) {
        if (!progressibleListeners.containsKey(progressible)) {
            Progress.createListenerList(progressible);
        }
        progressibleListeners.get(progressible).add(l);
    }

    private static synchronized void createListenerList(Object progressible) {
        if (progressibleListeners.containsKey(progressible)) {
            return;
        }
        progressibleListeners.put(progressible, new CopyOnWriteArrayList());
    }

    public static void complete() {
        Task t = progressibleStack.get().pop();
        if (!t.isComplete()) {
            t.complete();
            Progress.pingListeners(t);
        }
    }

    public static void ignore() {
        progressibleStack.get().push(IGNORED);
    }

    public static void register(Object progressible) {
        Progress.register(progressible, progressible.toString());
    }

    public static void register(Object progressible, String description) {
        ArrayDeque<Task> deque = progressibleStack.get();
        Task parent = deque.peek();
        Task t = parent == null || parent == IGNORED ? new Task(progressible, description) : new Task(progressible, parent, description);
        deque.push(t);
        Progress.pingListeners(deque.peek());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pingListeners(Task task) {
        if (task == IGNORED) {
            return;
        }
        List list = progressibleListeners.getOrDefault(task.progressible(), Collections.emptyList());
        List list2 = list;
        synchronized (list2) {
            for (Consumer l : list) {
                l.accept(task);
            }
        }
        for (Consumer consumer : globalListeners) {
            consumer.accept(task);
        }
        if (task.isSubTask()) {
            Progress.pingListeners(task.parent());
        }
    }

    public static Task currentTask() {
        return progressibleStack.get().peek();
    }

    public static void update() {
        Progress.update(1L);
    }

    public static void update(long elements) {
        Progress.update(elements, Progress.currentTask());
    }

    public static void update(long numElements, Task task) {
        task.update(numElements);
        Progress.pingListeners(task);
    }

    public static void setStatus(String status) {
        Progress.currentTask().setStatus(status);
        Progress.pingListeners(progressibleStack.get().peek());
    }

    public static void defineTotal(long elements) {
        Progress.currentTask().defineTotal(elements);
    }

    public static void defineTotal(long elements, long subTasks) {
        Progress.currentTask().defineTotal(elements, subTasks);
    }

    private static final class NOPTask
    extends Task {
        private static final double NOP_PROGRESS = 0.0;

        private NOPTask() {
            super(null, null, null);
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public void complete() {
        }

        @Override
        public void update(long numElements) {
        }

        @Override
        public double progress() {
            return 0.0;
        }

        @Override
        public void defineTotal(long elements, long subTasks) {
        }
    }
}

