/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class Task {
    private final Object progressible;
    private final Task parent;
    private final List<Task> subTasks = new CopyOnWriteArrayList<Task>();
    private boolean completed = false;
    private long totalTasks = 1L;
    private final AtomicLong current = new AtomicLong(0L);
    private final AtomicLong max = new AtomicLong(1L);
    private boolean tasksDefined = false;
    private final String description;
    private String status = "";

    public Task(Object progressible, String description) {
        this(progressible, null, description);
    }

    public Task(Object progressible, Task parent, String description) {
        this.progressible = progressible;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.subTasks.add(this);
        }
        this.description = description;
    }

    public void complete() {
        if (this.tasksDefined && this.progress() != 1.0) {
            String msg = "Task " + this.description();
            msg = this.current.longValue() != this.max.longValue() ? msg + " finished in the middle of a stage!" : msg + " has subtasks that did not complete!";
            throw new IllegalStateException(msg);
        }
        this.current.set(this.max.get());
        this.totalTasks = this.subTasks.size() + 1;
        this.completed = true;
    }

    public void defineTotal(long elements) {
        this.defineTotal(elements, 0L);
    }

    public void defineTotal(long elements, long subTasks) {
        if (elements > 0L) {
            this.totalTasks = subTasks + 1L;
            this.max.set(elements);
        } else if (subTasks > 0L) {
            this.totalTasks = subTasks;
            this.max.set(1L);
        } else {
            this.totalTasks = 1L;
            this.current.set(1L);
        }
        this.tasksDefined = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public double progress() {
        double totalCompletion = this.current.doubleValue() / this.max.doubleValue();
        for (Task t : this.subTasks) {
            totalCompletion += t.progress();
        }
        return totalCompletion / (double)this.totalTasks;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String status() {
        return this.status;
    }

    public String description() {
        return this.description;
    }

    protected void update(long numElements) {
        this.current.addAndGet(numElements);
    }

    public Object progressible() {
        return this.progressible;
    }

    protected Task parent() {
        return this.parent;
    }

    public boolean isSubTask() {
        return this.parent != null;
    }

    public String toString() {
        if (this.isComplete()) {
            return String.format("Progress of %s: Complete\n", this.description());
        }
        return String.format("Progress of %s: %.2f\n", this.description(), this.progress());
    }
}

