/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.spring;

import org.springframework.jdbc.core.JdbcTemplate;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.spring.SpringQuery;

public class SpringSimpleSession
implements SqlSession {
    JdbcTemplate jdbcTemplate;
    private String name;

    public SpringSimpleSession(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public SpringSimpleSession(JdbcTemplate jdbcTemplate, String name) {
        this(jdbcTemplate);
        this.name = name;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlQuery createSqlQuery(String queryString) throws SqlProcessorException {
        return new SpringQuery(this.jdbcTemplate, queryString);
    }

    public int[] executeBatch(String[] statements) throws SqlProcessorException {
        SqlQuery sqlQuery = this.createSqlQuery(null);
        return sqlQuery.executeBatch(statements);
    }

    public String getName() {
        return this.name;
    }
}

