/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaConst;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaIdent;
import org.sqlproc.engine.impl.SqlMetaOperator;
import org.sqlproc.engine.impl.SqlMetaText;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMetaIfItem
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<SqlMetaElement> elements = new ArrayList<SqlMetaElement>();

    SqlMetaIfItem() {
    }

    void addElement(SqlMetaElement element) {
        this.elements.add(element);
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult();
        result.addFalse();
        result.setSql(new StringBuilder());
        boolean like = false;
        boolean onlyText = true;
        boolean skipNextText = false;
        boolean skipNextIdent = false;
        for (SqlMetaElement item : this.elements) {
            SqlProcessResult itemResult;
            if ((item instanceof SqlMetaIdent || item instanceof SqlMetaConst || item instanceof SqlMetaIfItem) && !(item instanceof SqlMetaOperator)) {
                onlyText = false;
            }
            if (skipNextIdent && item instanceof SqlMetaIdent) {
                skipNextIdent = false;
                result.addTrue();
                continue;
            }
            if (!(item instanceof SqlMetaText)) {
                skipNextIdent = false;
            }
            if (!(itemResult = item.process(ctx)).isAdd() || skipNextText && item instanceof SqlMetaText) continue;
            if (item instanceof SqlMetaOperator && "is null".equalsIgnoreCase(itemResult.getSql().toString())) {
                skipNextIdent = true;
            }
            if ((item instanceof SqlMetaIdent || item instanceof SqlMetaConst || item instanceof SqlMetaIfItem) && !(item instanceof SqlMetaOperator)) {
                result.addTrue();
            }
            result.addInputValues(itemResult.getInputValues());
            result.addMappedInputValues(itemResult.getMappedInputValues());
            result.addOutputValues(itemResult.getOutputValues());
            result.addIdentities(itemResult.getIdentities());
            result.addOutValues(itemResult.getOutValues());
            if (item instanceof SqlMetaIdent && like && (SqlProcessContext.isFeature("SURROUND_QUERY_LIKE_PARTIAL") || SqlProcessContext.isFeature("SURROUND_QUERY_LIKE_FULL"))) {
                for (String ident : itemResult.getInputValues()) {
                    itemResult.getInputValue(ident).setLike(SqlProcessContext.getFeature("WILDCARD_CHARACTER"), SqlProcessContext.getFeatureAsInt("SURROUND_QUERY_MIN_LEN"), SqlProcessContext.isFeature("SURROUND_QUERY_LIKE_PARTIAL"));
                }
            } else if (item instanceof SqlMetaIdent && like && SqlProcessContext.getFeatureAsObject("REPLACE_LIKE_CHARS") != null) {
                for (String ident : itemResult.getInputValues()) {
                    itemResult.getInputValue(ident).setReplaceChars((Map)SqlProcessContext.getFeatureAsObject("REPLACE_LIKE_CHARS"));
                }
            } else if (item instanceof SqlMetaText && (SqlProcessContext.isFeature("SURROUND_QUERY_LIKE_PARTIAL") || SqlProcessContext.isFeature("SURROUND_QUERY_LIKE_FULL") || SqlProcessContext.getFeatureAsObject("REPLACE_LIKE_CHARS") != null) && itemResult.getSql().toString().trim().toLowerCase().endsWith(SqlProcessContext.getFeature("LIKE_STRING"))) {
                String replaceLike = SqlProcessContext.getFeature("REPLACE_LIKE_STRING");
                if (replaceLike != null) {
                    itemResult.setSql(new StringBuilder(itemResult.getSql().toString().toLowerCase().replace(SqlProcessContext.getFeature("LIKE_STRING"), replaceLike)));
                }
                like = true;
            } else if (!(like && item instanceof SqlMetaText && ((SqlMetaText)item).isWhite())) {
                like = false;
            }
            result.getSql().append((CharSequence)itemResult.getSql());
            skipNextText = itemResult.isSkipNextText();
        }
        if (onlyText && !SqlUtils.isEmpty(result.getSql())) {
            result.addTrue();
        }
        return result;
    }
}

